% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxmap--utilities.R
\name{obs}
\alias{obs}
\title{Get observations associated with taxa}
\usage{
obs(obj, subset = NULL, recursive = TRUE, simplify = FALSE)
}
\arguments{
\item{obj}{(\code{taxmap})
The \code{taxmap} object containing taxon information to be queried.}

\item{subset}{(\code{character}) \code{taxon_ids} or indexes of \code{taxon_data} for which
supertaxa will be returned. Default: All taxa in \code{obj} will be used.}

\item{recursive}{(\code{logical})
If \code{FALSE}, only return the observation assigned to the specified input taxa, not subtaxa.
If \code{TRUE}, return all the observations of every subtaxa, etc.}

\item{simplify}{(\code{logical}) If \code{TRUE}, then combine all the results into a single
vector of unique observation indexes.}
}
\value{
If \code{simplify = FALSE}, then a list of vectors of observation indexes are returned
  corresponding to the \code{target} argument. If \code{simplify = TRUE}, then the observation indexes
  for all \code{target} taxa are returned in a single vector.
}
\description{
Given one or more taxa IDs and a \code{\link{taxmap}} object, return the observation indexes
(e.g. sequence information) associated with each taxon.
}
\seealso{
Other taxmap taxonomy functions: \code{\link{roots}},
  \code{\link{subtaxa}}, \code{\link{supertaxa}}
}
