% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fasta.R
\name{read_fasta}
\alias{read_fasta}
\title{Read a FASTA file}
\usage{
read_fasta(file_path)
}
\arguments{
\item{file_path}{(\code{character} of length 1) The path to a file to read.}
}
\value{
named \code{character} vector
}
\description{
Reads a FASTA file. This is the FASTA parser for metacoder. It simply tries
to read a FASTA file into a named character vector with minimal fuss. It does
not do any checks for valid characters etc. Other FASTA parsers you might
want to consider include \code{\link[ape]{read.FASTA}} or
\code{\link[seqinr]{read.fasta}}.
}
\examples{

# Get example FASTA file
fasta_path <- system.file(file.path("extdata", "silva_subset.fa"),
                          package = "metacoder")

# Read fasta file
my_seqs <- read_fasta(fasta_path)

}
