% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/old_taxa--taxonomy--docs.R
\name{replace_taxon_ids}
\alias{replace_taxon_ids}
\title{Replace taxon ids}
\arguments{
\item{obj}{The [taxonomy()] or [taxmap()] object.}

\item{new_ids}{A vector of new ids, one per taxon. They must be unique and in
the same order as the corresponding ids in `obj$taxon_ids()`.}
}
\value{
A [taxonomy()] or [taxmap()] object with new taxon ids
}
\description{
Replace taxon ids in a [taxmap()] or [taxonomy()] object.
\preformatted{
obj$replace_taxon_ids(new_ids)
replace_taxon_ids(obj, new_ids)}
}
\examples{
# Replace taxon IDs with numbers
replace_taxon_ids(ex_taxmap, seq_len(length(ex_taxmap$taxa)))

# Make taxon IDs capital letters
replace_taxon_ids(ex_taxmap, toupper(taxon_ids(ex_taxmap)))

}
