\name{radial.rma}
\alias{radial.rma}
\title{Radial Plots for rma Objects}
\description{Function to create radial (Galbraith) plots for objects of class \code{"rma"}.}
\usage{
\method{radial}{rma}(x, center=FALSE, xlim=NULL, zlim=NULL, xlab=NULL, zlab=NULL, 
       atz=NULL, aty=NULL, steps=7, level=x$level, digits=2, 
       back="lightgray", transf=FALSE, targs=NULL, pch=19, 
       arc.res = 100, cex=NULL, ...)
}
\arguments{
	\item{x}{an object of class \code{"rma"}.}
	\item{center}{logical to indicate whether the plot should be centered horizontally at the model estimate (default is \code{FALSE}).}
	\item{xlim}{x axis limits. Defaults to \code{NULL}, which means that the function tries to set the x axis limits to some sensible values.}
	\item{zlim}{z axis limits. Defaults to \code{NULL}, which means that the function tries to set the z axis limits to some sensible values (note that the z axis limits are the actual vertical limit of the plotting region).}
	\item{xlab}{title for the x axis. Defaults to \code{NULL}, which means that a label is generated by the function.}
	\item{zlab}{title for the z axis. Defaults to \code{NULL}, which means that a label is generated by the function.}
	\item{atz}{position for the z axis tick marks and labels. Defaults to \code{NULL}, which means that these are set by the function.}
	\item{aty}{position for the y axis tick marks and labels. Defaults to \code{NULL}, which means that these are set by the function.}
	\item{steps}{the number of tick marks and corresponding labels for the y axis (default is 7). Ignored when argument \code{aty} is used.}
	\item{level}{a numerical value between 0 and 100 specifying the level of the z axis error region (the default is to take the value from the object).}
	\item{digits}{an optional integer value specifying the number of decimal places to which the y axis tick mark labels should be rounded (default is 2).}
	\item{back}{color of the z axis error region. Set to \code{NA} to suppress shading of the region.}
	\item{transf}{an optional argument specifying the name of a function that should be used to transform the y axis labels (e.g., \code{transf=exp}). Defaults to \code{FALSE}, which means that no transformation is used.}
	\item{targs}{optional arguments needed by the function specified via \code{transf}.}
	\item{pch}{plotting symbol. By default, a solid circle is used. See \code{\link{points}} for other options.}
	\item{arc.res}{integer value specifying the number of line segments to use when drawing the y axis and confidence interval arcs (default is 100).}
	\item{cex}{an optional character and symbol expansion factor. If \code{NULL} (default), the function tries to set this to a sensible value.}
	\item{...}{other arguments.}
}
\details{
	For a fixed-effects model, the plot shows the inverse of the standard errors on the horizontal axis against the individual observed effect sizes or outcomes standardized by their corresponding standard errors on the vertical axis. Since the vertical axis corresponds to standardized values, it is referred to as the z axis within this function. On the right hand side of the plot, an arc is drawn (referred to as the y axis within this function) corresponding to the individual observed effect sizes or outcomes. A line projected from (0,0) through a particular point within the plot onto this arc indicates the value of the individual observed effect size or outcome for that point.

	For a random-effects model, the function uses \eqn{1/\sqrt{v_i + \tau^2}}{1/sqrt(v_i + tau^2)} for the horizontal axis, where \eqn{v_i} is the sampling variance of the observed effect size or outcome and \eqn{\tau^2}{tau^2} is the amount of heterogeneity as estimated based on the model. For the z axis, \eqn{\sqrt{v_i + \tau^2}}{sqrt(v_i + tau^2)} is used to standardize the individual observed effect sizes or outcomes.

	If the model contains moderators, the function returns an error.
}
\author{Wolfgang Viechtbauer; \email{wvb@www.wvbauer.com}; \url{http://www.wvbauer.com/}}
\references{
	Galbraith, R. F. (1988) Graphical display of estimates having differing standard errors. \emph{Technometrics}, \bold{30}, 271--281.

	Galbraith, R. F. (1988) A note on graphical presentation of estimated odds ratios from several clinical trials. \emph{Statistics in Medicine}, \bold{7}, 889--894.

	Galbraith, R. F (1994). Some applications of radial plots. \emph{Journal of the American Statistical Association}, \bold{89}, 1232--1242.
}
\seealso{
	\code{\link{rma.uni}}, \code{\link{rma.mh}}, \code{\link{rma.peto}}, 
}
\examples{
### load BCG vaccine data
data(dat.bcg)

### meta-analysis of the log risk ratios using a fixed-effects model
res <- rma(ai=tpos, bi=tneg, ci=cpos, di=cneg, 
           data=dat.bcg, measure="RR", method="FE")
radial(res)

### line from (0,0) with slope of the log risk ratio from the 4th study
abline(a=0, b=c(-1.44155119))

### meta-analysis of the log risk ratios using a random-effects model
res <- rma(ai=tpos, bi=tneg, ci=cpos, di=cneg, 
           data=dat.bcg, measure="RR", method="REML")
radial(res)
}
\keyword{hplot}
