% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_ae_specific.R
\name{format_ae_specific}
\alias{format_ae_specific}
\title{Format AE specific analysis}
\usage{
format_ae_specific(
  outdata,
  display = c("n", "prop", "total"),
  digits_prop = 1,
  digits_ci = 1,
  digits_p = 3,
  digits_dur = c(1, 1),
  digits_events = c(1, 1),
  mock = FALSE
)
}
\arguments{
\item{outdata}{A \code{outdata} object created by \code{\link[=prepare_ae_specific]{prepare_ae_specific()}}.}

\item{display}{A character vector of measurement to be displayed:
\itemize{
\item \code{n}: Number of subjects with AE.
\item \code{prop}: Proportion of subjects with AE.
\item \code{total}: Total columns.
\item \code{diff}: Risk difference.
\item \code{diff_ci}: 95\% confidence interval of risk difference using M&N method.
\item \code{diff_p}: p-value of risk difference using M&N method.
\item \code{dur}: Average of AE duration.
\item \code{events}: Average number of AE per subject.
}}

\item{digits_prop}{A numeric value of number of digits for proportion value.}

\item{digits_ci}{A numeric value of number of digits for confidence interval.}

\item{digits_p}{A numeric value of number of digits for p-value.}

\item{digits_dur}{A numeric value of number of digits for average
duration of AE.}

\item{digits_events}{A numeric value of number of digits for average of
number of AE per subjects.}

\item{mock}{A boolean value to display mock table.}
}
\value{
A list of analysis raw datasets.
}
\description{
Format AE specific analysis
}
\examples{
meta <- meta_ae_example()

outdata <- prepare_ae_specific(meta,
  population = "apat",
  observation = "wk12",
  parameter = "rel"
)

# Basic example
tbl <- outdata |>
  format_ae_specific()
head(tbl$tbl)

# Display different measurements
tbl <- outdata |>
  extend_ae_specific_events() |>
  format_ae_specific(display = c("n", "prop", "events"))
head(tbl$tbl)
}
