% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barplots.R
\name{barplots}
\alias{barplots}
\alias{plot_bars}
\alias{plot_factbars}
\title{Fast way to create bar plots}
\usage{
plot_bars(
  .data,
  x,
  y,
  order = NULL,
  y.lim = NULL,
  y.breaks = waiver(),
  y.expand = 0.05,
  xlab = NULL,
  ylab = NULL,
  n.dodge = 1,
  check.overlap = FALSE,
  color.bar = "black",
  fill.bar = "gray",
  lab.bar = NULL,
  lab.bar.hjust = 0.5,
  lab.bar.vjust = -0.5,
  lab.bar.angle = 0,
  size.text.bar = 5,
  lab.x.hjust = 0.5,
  lab.x.vjust = 1,
  lab.x.angle = 0,
  errorbar = TRUE,
  stat.erbar = "se",
  width.erbar = NULL,
  level = 0.95,
  invert = FALSE,
  width.bar = 0.9,
  size.line = 0.5,
  size.text = 12,
  fontfam = "sans",
  na.rm = TRUE,
  verbose = FALSE,
  plot_theme = theme_metan()
)

plot_factbars(
  .data,
  ...,
  resp,
  y.lim = NULL,
  y.breaks = waiver(),
  y.expand = 0.05,
  xlab = NULL,
  ylab = NULL,
  n.dodge = 1,
  check.overlap = FALSE,
  lab.bar = NULL,
  lab.bar.hjust = 0.5,
  lab.bar.vjust = -0.5,
  lab.bar.angle = 0,
  size.text.bar = 5,
  lab.x.hjust = 0.5,
  lab.x.vjust = 1,
  lab.x.angle = 0,
  errorbar = TRUE,
  stat.erbar = "se",
  width.erbar = NULL,
  level = 0.95,
  invert = FALSE,
  col = TRUE,
  palette = "Spectral",
  width.bar = 0.9,
  legend.position = "bottom",
  size.line = 0.5,
  size.text = 12,
  fontfam = "sans",
  na.rm = TRUE,
  verbose = FALSE,
  plot_theme = theme_metan()
)
}
\arguments{
\item{.data}{The data set.}

\item{x, y}{Argument valid for \code{plot_bars()} The variables to be mapped
to the \code{x} and \code{y} axes, respectively.}

\item{order}{Argument valid for \code{plot_bars()}. Controls the order of the
factor in the \code{x} axis. Defaults to the order of the factors in
\code{.data}. Use \code{order = "asce"} or \code{order = "desc"} to reorder
the labels to ascending or descending order, respectively, based on the
values of the variable \code{y}.}

\item{y.lim}{The range of y axis. Defaults to \code{NULL} (maximum and
minimum values of the data set). New values can be inserted as \code{y.lim
  = c(y.min, y.max)}.}

\item{y.breaks}{The breaks to be plotted in the y-axis. Defaults to waiver().
\code{authomatic breaks}. The same arguments than \code{x.breaks} can be
used.}

\item{y.expand}{A multiplication range expansion factor. Defaults to
\code{0.05}.}

\item{xlab, ylab}{The labels of the axes x and y, respectively. Defaults to
\code{NULL}.}

\item{n.dodge}{The number of rows that should be used to render the x labels.
This is useful for displaying labels that would otherwise overlap.}

\item{check.overlap}{Silently remove overlapping labels, (recursively)
prioritizing the first, last, and middle labels.}

\item{color.bar, fill.bar}{Argument valid for \code{plot_bars()}. The color and
fill values of the bars.}

\item{lab.bar}{A vector of characters to show in each bar. Defaults to NULL.}

\item{lab.bar.hjust, lab.bar.vjust}{The horizontal and vertical adjust for the
labels in the bar. Defaults to 0.5 and -0.5, respectively.}

\item{lab.bar.angle}{The angle for the labels in the plot. Defaults to 0. Use
in combination with \code{lab.bar.hjust} and \code{lab.bar.vjust} to best
fit the labels in the plot.}

\item{size.text.bar}{The size of the text in the bar labels.}

\item{lab.x.hjust, lab.x.vjust}{The horizontal and vertical adjust for the
labels in the bar. Defaults to 0.5 and 1, respectively.}

\item{lab.x.angle}{The angle for the labels in x axis. Defaults to 0. Use
in combination with \code{lab.x.hjust} and \code{lab.x.vjust} to best
fit the labels in the axis.}

\item{errorbar}{Logical argument, set to TRUE. In this case, an error bar is
shown.}

\item{stat.erbar}{The statistic to be shown in the errorbar. Must be one of
the \code{stat.erbar = "se"} (standard error, default), \code{stat.erbar =
  "sd"} (standard deviation), or \code{stat.erbar = "ci"} (confidence
interval), based on the confidence level in the argument \code{level}.}

\item{width.erbar}{The width of the error bar. Defaults to 30\% of
\code{width.bar}.}

\item{level}{The confidence level}

\item{invert}{Logical argument. If \code{TRUE}, rotate the plot in
\code{plot_bars()} and invert the order of the factors in
\code{plot_factbars()}.}

\item{width.bar}{The width of the bars in the graph. Defaults to 0.9.
Possible values are in the range 0-1.}

\item{size.line}{The size of the line in the bars. Default to \code{0.5}.}

\item{size.text}{The size of the text. Default to \code{12}.}

\item{fontfam}{The family of the font text. Defaults to \code{"sans"}.}

\item{na.rm}{Should 'NA' values be removed to compute the statistics?
Defaults to true}

\item{verbose}{Logical argument. If TRUE a tibble containing the mean, N,
standard deviation, standard error of mean and confidence interval is
returned.}

\item{plot_theme}{The graphical theme of the plot. Default is
\code{plot_theme = theme_metan()}. For more details, see
\code{\link[ggplot2]{theme}}.}

\item{...}{Argument valid for \code{plot_factbars()}. A comma-separated list
of unquoted variable names. Sets the two variables to be mapped to the
\code{x} axis.}

\item{resp}{Argument valid for \code{plot_factbars()}. The response variable
to be mapped to the y axis.}

\item{col}{Logical argument valid for \code{plot_factbars()}. If
\code{FALSE}, a gray scale is used.}

\item{palette}{Argument valid for \code{plot_factbars()} The color palette to
be used. For more details, see \code{?scale_colour_brewer}}

\item{legend.position}{The position of the legend in the plot.}
}
\value{
An object of class \code{gg, ggplot}.
}
\description{
\itemize{
\item \code{plot_bars()} Creates a bar plot based on one categorical variable and
one numeric variable.  It can be used to show the results of a one-way trial
with \strong{qualitative treatments}.
\item \code{plot_factbars()} Creates a bar plot based on two categorical
variables and one numeric variable.  It can be used to show the results of a
two-way trial with \strong{qualitative-qualitative treatment structure}.
}
}
\examples{
\donttest{
library(metan)
# two categorical variables
plot_factbars(data_ge2,
              GEN,
              ENV,
              resp = PH)

# one categorical variable
p1 <- plot_bars(data_g, GEN, PH)
p2 <- plot_bars(data_g, GEN, PH,
                n.dodge = 2, # two rows for x labels
                y.expand = 0.1, # expand y scale
                errorbar = FALSE, # remove errorbar
                color.bar = "red", # color of bars
                fill.bar = alpha_color("cyan", 75), # create a transparent color
                lab.bar = letters[1:13], # add labels
                plot_theme = ggplot2::theme_gray()) #change plot themes
arrange_ggplot(p1, p2)
}
}
\seealso{
\code{\link{plot_lines}}, \code{\link{plot_factlines}}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
