% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatter.R
\name{scatter.folded}
\alias{scatter.folded}
\title{Scatterplot for Folded}
\usage{
\method{scatter}{folded}(x, yvar, xvar, groups = NULL, ..., ylog = log,
  xlog = log, yref = NULL, xref = NULL, ysmooth = FALSE,
  xsmooth = FALSE, cols = 3, auto.key = list(columns = cols),
  density = FALSE, iso = FALSE, main = FALSE, corr = FALSE,
  crit = 1.3, na.rm = TRUE, fit = conf, log = FALSE, conf = FALSE,
  loc = 0, msg = "metastats", panel = metapanel)
}
\arguments{
\item{x}{folded}

\item{yvar}{y values}

\item{xvar}{x values}

\item{groups}{optional grouping item}

\item{...}{passed to \code{\link{region}}}

\item{ylog}{reference line from y axis}

\item{xlog}{reference line from x axis}

\item{yref}{reference line from y axis}

\item{xref}{reference line from x axis}

\item{ysmooth}{supply loess smooth of y on x}

\item{xsmooth}{supply loess smmoth of x on y}

\item{cols}{default columns for auto.key}

\item{auto.key}{passed to \code{\link[lattice]{xyplot}}}

\item{density}{plot point density instead of points}

\item{iso}{use isometric axes with line of unity}

\item{main}{logical: whether to construct a default title; or a substitute title or NULL}

\item{corr}{append Pearson correlation coefficient to default title (only if main is \code{TRUE})}

\item{crit}{if ylog or xlog missing, log transform if mean/median ratio for non-missing values is greater than crit}

\item{na.rm}{whether to remove data points with one or more missing coordinates}

\item{fit}{draw a linear fit of y ~ x}

\item{log}{default for ylog and xlog}

\item{conf}{logical, or width for a confidence region around a linear fit; passed to \code{\link{region}}; \code{TRUE} defaults to 95 percent confidence interval}

\item{loc}{where to print statistics on a panel}

\item{msg}{a function to print text on a panel: called with x values, y values, and \dots.}

\item{panel}{default panel function}
}
\description{
Scatterplot for class 'folded'.
}
\seealso{
Other bivariate plots: \code{\link{boxplot.folded}},
  \code{\link{metaplot.data.frame}},
  \code{\link{metaplot.folded}},
  \code{\link{scatter.data.frame}},
  \code{\link{scatter_data_frame}}

Other scatter: \code{\link{scatter.data.frame}},
  \code{\link{scatter_data_frame}}
}
