% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clust_algs_list.R
\name{generate_clust_algs_list}
\alias{generate_clust_algs_list}
\title{Generate a list of custom clustering algorithms}
\usage{
generate_clust_algs_list(..., disable_base = FALSE)
}
\arguments{
\item{...}{An arbitrary number of named clustering functions (see examples
below)}

\item{disable_base}{If TRUE, do not prepend the base clustering algorithms
(spectral_eigen and spectral_rot, which apply spectral clustering and use
the eigen-gap and rotation cost heuristics respectively for determining
the number of clusters in the graph.}
}
\value{
A list of clustering algorithm functions that can
be passed into the batch_snf and generate_settings_list functions.
}
\description{
This function can be used to specify custom clustering algorithms to apply
to the final similarity matrices produced by each run of the batch_snf
function.
}
\examples{
# Using just the base clustering algorithms --------------------------------
# This will just contain spectral_eigen and spectral_rot
clust_algs_list <- generate_clust_algs_list()

# Adding algorithms provided by the package --------------------------------
# This will contain the base clustering algorithms (spectral_eigen,
#  spectral_rot) as well as two pre-defined spectral clustering functions
#  that force the number of clusters to be two or five
clust_algs_list <- generate_clust_algs_list(
    "two_cluster_spectral" = spectral_two,
    "five_cluster_spectral" = spectral_five
)

# Adding your own algorithms -----------------------------------------------
# This will contain the base and user-provided clustering algorithms
my_clustering_algorithm <- function(similarity_matrix) {
    # your code that converts similarity matrix to clusters here...
    # solution_data <- list(
    #     "solution" = solution,
    #     "nclust" = number_of_clusters
    # )
    # return(solution_data)
}

# Suppress the base algorithms----------------------------------------------
# This will contain only user-provided clustering algorithms

clust_algs_list <- generate_clust_algs_list(
    "two_cluster_spectral" = spectral_two,
    "five_cluster_spectral" = spectral_five,
    disable_base = TRUE
)

}
