% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel.R
\name{parallel_batch_snf}
\alias{parallel_batch_snf}
\title{Parallel processing form of batch_snf}
\usage{
parallel_batch_snf(
  dl,
  dfl,
  cfl,
  sdf,
  wm,
  similarity_matrix_dir,
  return_sim_mats,
  processes
)
}
\arguments{
\item{dl}{A data list.}

\item{dfl}{An optional nested list containing which
distance metric function should be used for the various feature types
(continuous, discrete, ordinal, categorical, and mixed). See
?dist_fns_list for details on how to build this.}

\item{cfl}{List of custom clustering algorithms to apply
to the final fused network. See ?clust_fns_list.}

\item{sdf}{matrix indicating parameters to iterate SNF through.}

\item{wm}{A matrix containing feature weights to use during
distance matrix calculation. See ?weights_matrix for details on
how to build this.}

\item{similarity_matrix_dir}{If specified, this directory will be used to
save all generated similarity matrices.}

\item{return_sim_mats}{If TRUE, function will return a list where
the first element is the solutions data frame and the second element is a list
of similarity matrices for each row in the sol_df. Default FALSE.}

\item{processes}{Number of parallel processes used when executing SNF.}
}
\value{
The same values as ?batch_snf().
}
\description{
Parallel processing form of batch_snf
}
\keyword{internal}
