% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_summary.R
\name{summary.umbrella}
\alias{summary.umbrella}
\title{Synthesize information of an object of class \dQuote{umbrella} in a dataframe}
\usage{
\method{summary}{umbrella}(object, digits = 3, ...)
}
\arguments{
\item{object}{an object of class \dQuote{umbrella}}

\item{digits}{an integer value specifying the number of decimal places for the rounding of numeric values. Default is 3.}

\item{...}{other arguments that can be passed to the function}
}
\value{
All main results of an object of class \dQuote{umbrella} are synthesized in a dataframe, with the results of each factors stored in their own row.
Depending on the classification used, the dataframe returned include certain information presented below:
\tabular{ll}{
\code{Factor} \tab the name of the factor\cr
\tab \cr
\code{Class} \tab the class assigned during the stratification of evidence\cr
\tab \cr
\code{n_studies} \tab the number of independent studies included in the factor\cr
\tab \cr
\code{total_n} \tab the total number of participants included in the factor\cr
\tab \cr
\code{n_cases} \tab the number of cases included in the factor\cr
\tab \cr
\code{n_controls} \tab the number of controls included in the factor\cr
\tab \cr
\code{measure} \tab the measured used in the calculations\cr
\tab \cr
\code{value} \tab the value of the pooled effect size expressed in its original metric. Note that\cr
\tab  if a factor includes only one study, its value and 95\% CI are equal to the effect\cr
\tab  size value and 95\% CI of the individual study\cr
\tab \cr
\code{value_CI} \tab the 95\% confidence interval (CI) around the pooled effect size\cr
\tab expressed in its original metric\cr
\tab \cr
\code{eG} \tab the value of the pooled effect size expressed in equivalent Hedges' g (eG)\cr
\tab \cr
\code{eG_CI} \tab the 95\% CI around the pooled effect size expressed in eG\cr
\tab \cr
\code{eOR} \tab the value of the pooled effect size expressed in equivalent Odds ratio (eOR)\cr
\tab \cr
\code{eOR_CI} \tab the 95\% CI around the pooled effect size expressed in eOR\cr
\tab \cr
\code{p_value} \tab the p-value of the pooled effect size\cr
\tab \cr
\code{I2} \tab the inconsistency (\eqn{I^2}) value (calculated only if the number of studies in the\cr
\tab meta-analysis is equal or larger to 2)\cr
\tab \cr
\code{PI_eG} \tab the 95\% prediction interval (PI) expressed in eG (calculated only if the number\cr
\tab of studies in the meta-analysis is equal or larger to 3)\cr
\tab \cr
\code{PI_eOR} \tab the 95\% PI expressed in eOR (calculated only if the number of studies in the \cr
\tab meta-analysis is equal or larger to 3)\cr
\tab \cr
\code{PI_sign} \tab whether the 95\% PI includes the null value ("notnull" vs. "null)\cr
\tab \cr
\code{egger_p} \tab the p-value of the Egger's test for publication bias (calculated only\cr
\tab if the number of studies in the meta-analysis is equal or larger to 3)\cr
\tab \cr
\code{egger_sign} \tab whether the p-value of the Egger's test is < .05 ("sig." vs. "ns)\cr
\tab \cr
\code{ESB_p} \tab the Ioannidis' test for excess of significance\cr
\tab \cr
\code{ESB_sign} \tab whether the p-value of the Ioannidis' test is < .05 ("sig." vs. "ns)\cr
\tab \cr
\code{power_med} \tab the power to detect a SMD of 0.5 at an alpha of .05 based on the number of\cr
\tab cases and controls included in the meta-analysis (when IRR is used as effect size\cr
\tab measure the number of cases and controls in this calculation is assumed to be equal to\cr
\tab half the total number of cases included in the meta-analysis\cr
\tab \cr
\code{power} \tab present only in the 'Personalized' classification. \cr
\tab If the user did not use the 'power' criteria to stratify the evidence, this column \cr
\tab contains the power to detect a small effect size (SMD = 0.2), a moderate effect size  \cr
\tab (SMD = 0.5) and a large effect size (SMD = 0.8) at an alpha of .05 based on the\cr
\tab number of cases and controls included in the meta-analysis.\cr
\tab If the user used the 'power' criteria to stratify the evidence, this column contains\cr
\tab the power to detect the values entered by the user at an alpha of .05 based on the \cr
\tab number of cases and controls included in the meta-analysis.\cr
\tab \cr
\code{JK_p} \tab the largest p-value obtained in the jackknife leave-one-out meta-analysis (calculated\cr
\tab only if the number of studies in the meta-analysis is equal or larger to 2)\cr
\tab \cr
\code{JK_sign} \tab whether the largest p-value in the jackknife meta-analysis is < .05 ("sig." vs. "ns")\cr
\tab \cr
\code{largest_CI_eG} \tab the 95\% CI of the largest study expressed in eG\cr
\tab \cr
\code{largest_CI_eOR} \tab the 95\% CI of the largest study expressed in eOR\cr
\tab \cr
\code{largest_sign} \tab whether the 95\% CI of the largest study includes the null value ("notnull" vs. \cr
\tab "null)\cr
\tab \cr
\code{rob} \tab the percentage of participants included in studies at low risk of bias (calculated\cr
\tab only if this information is indicated in the dataset)\cr
\tab \cr
\code{amstar} \tab the AMSTAR score of the meta-analysis (calculated only if this information is\cr
\tab indicated in the dataset)\cr
\tab \cr
}
}
\description{
Synthesize information of an object of class \dQuote{umbrella} in a dataframe
}
\details{
Summary method for objects of class \dQuote{umbrella}.
}
\examples{
### generate a summary of the results of an umbrella object
summary(umbrella(df.SMD))
}
\seealso{
\code{\link{metaumbrella-package}()} for the formatting of well-formatted datasets.
\code{\link{umbrella}()} for conducting calculations needed for an umbrella review.
\code{\link{add.evidence}()} for adding evidence classes to an umbrella review.
}
