% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalue_main.R
\name{varevalue.signle_general}
\alias{varevalue.signle_general}
\title{A general method to calculate the e-value for the Metilene alike gene data with specified start and end sits}
\usage{
varevalue.signle_general(
  methyrate,
  group1_name = "g1",
  group2_name = "g2",
  chr,
  start,
  end
)
}
\arguments{
\item{methyrate}{data.frame: A data.frame object of methylation rates, the columns should be(name of groups can be self-defined)

chr    pos    group1_name group1_name ... group1_name group2_name group2_name}

\item{group1_name}{charactor: The name of the first group. For example, "treated" in the above example.}

\item{group2_name}{charactor: The name of the second group. For example, "untreated" in the above example.}

\item{chr}{charactor: The Chromosome name. Typically, it is a string like "chr21" and so on.}

\item{start}{integer:  The position of the start site of the corresponding region}

\item{end}{integer: The position of the end site of the corresponding region}
}
\value{
evalue
}
\description{
Perform the Evaluation for the Metilene data. The data file could be pre-handled by the metevalue.[types].chk function.
The  Chromosome name, start and end sits shoule be specified.
}
\examples{
data("demo_metilene_out")
data("demo_metilene_input")
# result = evalue_buildin_var_fmt_nm(demo_metilene_input,
#         demo_metilene_out, method="metilene")
# a_b = evalue_buildin_sql(result$a, result$b, method = 'metilene')
# varevalue.signle_general(a_b, chr = "chr21", start = 9437432, end = 9437540)
# [1] 2.626126e+43

#### Compare to `varevalue.metilene`  ####
# resultx = list(a = result$a,
#           b = result$b,
#           a_b = evalue_buildin_sql(result$a, result$b, method = method_in_use))
# result_met = varevalue.metilene(resultx$a, resultx$b, resultx$a_b)
# result_met[with(result_met, chr == 'chr21' & start == '9437432' & end == '9437540'), ]
# [1] 2.626126e+43
}
