% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sesSingle.R
\name{sesSingle}
\alias{sesSingle}
\title{Summary of results from a single iteration}
\usage{
sesSingle(single.iteration, concat.by)
}
\arguments{
\item{single.iteration}{The results of a single iteration from multiLinker.}

\item{concat.by}{Whether randomizations were concatenated by richness, plot or both.}
}
\value{
A data frame summarizing the mean of standardized effect sizes and the
significance of those devations from expectations for a given iteration (e.g. the
plots from a given arena). It does consider all spatial simulations, nulls and
metrics from that iteration. This test works across a single iteration, and will
generally not be used by itself; it is called by sesIndiv.
}
\description{
Use Wilcoxon signed rank test to determine whether plots from a SINGLE iteration
differ from expectations
}
\details{
This function uses a Wilcoxon signed rank test to determine whether the
plots from a spatial simulation/null/metric from a SINGLE iteration differ from
expectations. Assuming there are three spatial simulations named random, filtering, and
competition, this function will use two.sided, lesser and greater Wilcoxon tests,
respectively.
}
\examples{
#not run
#results <- readIn()
#summ <- sesSingle(results[[1]], "richness")
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2015. Phylogenetic community
structure metrics and null models: a review with new methods and software.
bioRxiv 025726.
}

