% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispersalNull.R
\name{dispersalNull}
\alias{dispersalNull}
\title{Randomize community data matrix with dispersal null model}
\usage{
dispersalNull(picante.cdm, tree, distances.among, abundance.matters = TRUE,
  abundance.assigned = "directly")
}
\arguments{
\item{picante.cdm}{Picante-style community data matrix with
communities/plots/plots/etc as rows and species as columns}

\item{tree}{Phylo object}

\item{distances.among}{A symmetric distance matrix, summarizing the distances among all
plots from the cdm.}

\item{abundance.matters}{Default is TRUE. If FALSE, species are sampled from
neighboring grid cells with equal probability.}

\item{abundance.assigned}{Default is "directly". If set to "explore", rather than
assigning species abundances equal to those in neighboring cells, a normal distribution
of standard deviation 1 is created around that abundance, rounded to whole numbers,
negative numbers are converted to 1, and then abundance is assigned from this
distribution. Note, importantly, that if the cdm is a relative abundance matrix, as
opposed to an absolute abundance matrix, if "explore" is chosen, odd results are likely
(don't do it). If set to "overall", which may be preferable when abundance.matters is
set to FALSE, species' are assigned abundances by drawing from the vector of non-zero
abundances from the original cdm.}
}
\value{
A matrix with the same dimensions as the input cdm.
}
\description{
Null model that maintains species richness and settles species in simulated plots 
with a probability proportional to their abundance in and distance from the plot in
question.
}
\details{
This function can run quite slowly, as it employs a while loop to discard
selected species if they are already contained in the plot being simulated. The
function contains an internal check to ensure that it doesn't get stuck in an
indefinite while loop. Specifically, it checks that an observed plot does not
contain more species than the sum of unique species in the remaining plots. The
argument distances.among is flexible, and can relate to e.g., straight-line distances,
great-circle distances, and ecological distances. If the argument abundance.matters is
set to FALSE, then species' abundances in neighboring grid cells does not influence
their probability of settling (only their proximity influences the probability of
settling). If this is the case, it is recommended that the argument abundance.assigned
be set to "overall".
}
\examples{
#set up a matrix to simulate lat/long
coordDF <- matrix(ncol=2, nrow=100)

coordDF[,1] <- runif(n=100, min=40, max=50)
coordDF[,2] <- runif(n=100, min=-130, max=-120)

#convert to data frame, give column names. also give row names such as if the cells had
#names (as they should or there'd be no way to track them)
coordDF <- as.data.frame(coordDF)

row.names(coordDF) <- paste("cell", 1:100, sep="")

names(coordDF) <- c("latitude","longitude")

#calculate the distances among all of these points. in the real program you're going to
#want to calculate great arc distance or whatever it's called
distances <- dist(coordDF, diag=TRUE, upper=TRUE)

#turn it into a symmetric distance matrix
distances <- as.matrix(distances)

#simulate a regional phylogeny of 100 species
tree <- geiger::sim.bdtree(b=1, d=0, stop="taxa", n=100)

#simulate a community data matrix of 100 cells by 100 species. do it 4 times so that
#you can use your simulateComm function and have it span a reasonable range of richness
sim.abundances <- round(rlnorm(5000, meanlog=2, sdlog=1)) + 1

cdm1 <- simulateComm(tree, richness.vector=10:34, abundances=sim.abundances)
cdm2 <- simulateComm(tree, richness.vector=10:34, abundances=sim.abundances)
cdm3 <- simulateComm(tree, richness.vector=10:34, abundances=sim.abundances)
cdm4 <- simulateComm(tree, richness.vector=10:34, abundances=sim.abundances)

#bind these into a list and use dplyr rbind_all to bind together. recast as data frame

cdmList <- list(cdm1, cdm2, cdm3, cdm4)

cdm <- dplyr::bind_rows(cdmList)

cdm <- as.data.frame(cdm)

#fix as necessary manually here (i.e. make sure dimensions are 100 x 100), seems to 
#usually work. then give cell names

row.names(cdm) <- paste("cell", 1:100, sep="")

#fill NAs with 0s.

cdm[is.na(cdm)] <- 0

#not run
#newCDM <- dispersalNull(cdm, tree, distances)
}
\references{
Miller, E. T. 2016. A new dispersal-informed null model for
community ecology shows strong performance. biorxiv.
}
