% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPlacer.R
\name{plotPlacer}
\alias{plotPlacer}
\title{Randomly place plots in arena}
\usage{
plotPlacer(no.plots, arena.length, plot.length)
}
\arguments{
\item{no.plots}{Number of plots to place}

\item{arena.length}{Length of one side of arena}

\item{plot.length}{Length of one side of desired plot.}
}
\value{
A matrix with the X & Y coordinates of the four corners of each plot placed
}
\description{
Given a desired number of plots, the arena size, and the plot size, will attempt
to place plots down in a non-overlapping fashion
}
\details{
Places plots down in non-overlapping fashion according to parameters
supplied. Because this would run indefinitely if unacceptable parameters were supplied,
a conservative check is implemented to "ensure" the function does not get stuck. If
unacceptable parameters are supplied, will return an arena and a smaller total sampling
area will need to be defined.
}
\examples{

boundResults <- plotPlacer(no.plots=10, arena.length=300,
plot.length=50)
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2016. Phylogenetic community
structure metrics and null models: a review with new methods and software.
Ecography DOI: 10.1111/ecog.02070
}
