% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d1r.R
\name{d1r}
\alias{d1r}
\title{Refined Index of Agreement (d1).}
\usage{
d1r(data = NULL, obs, pred, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (numeric).}

\item{pred}{Vector with predicted values (numeric).}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric}.
}
\description{
It estimates the refined index of agreement (d1r) following
Willmott et al. (2012).
}
\details{
Similar to d, and d1, the d1r index it is a normalized, dimensionless
metric that tests general agreement. The difference is that d1r modifies the
denominator of the formula (potential error), normalizing the mean absolute error
(numerator) by two-times the mean absolute deviation of observed values. It is
bounded between 0 and 1. The disadvantage is that d1r is an asymmetric index,
that is, dependent to the orientation of predicted and observed values.
For the formula and more details, see \href{https://adriancorrendo.github.io/metrica/articles/available_metrics.html}{online-documentation}
}
\examples{
\donttest{
set.seed(1)
X <- rnorm(n = 100, mean = 0, sd = 10)
Y <- rnorm(n = 100, mean = 0, sd = 9)
d1r(obs = X, pred = Y)
}
}
\references{
Willmott et al. (2012).
A refined index of model performance.
\emph{Int. J. Climatol. 32, 2088–2094.} \doi{10.1002/joc.2419}
}
