% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slido.R
\name{get_slido_files}
\alias{get_slido_files}
\title{Get Slido Files}
\usage{
get_slido_files(
  drive_id,
  token = NULL,
  recursive = TRUE,
  keep_duplicates = FALSE
)
}
\arguments{
\item{drive_id}{a URL or drive id that has the slido response output files you are looking to get (will recursively search for files by default).}

\item{token}{credentials for access to Google using OAuth. `authorize("google")`}

\item{recursive}{Should slido files be looked for recursively in this folder? default is TRUE.}

\item{keep_duplicates}{By default we won't keep duplicated files if a two files have the same name. But if you set this to true, duplicates will be returned.}
}
\value{
A list of the slido files and their content in a Googledrive location.
}
\description{
This is a function to get slido response output files.
The slido files must be saved as googlesheets and cannot be xlsx.
The scope it uses is the `See, edit, create, and delete all your Google Sheets spreadsheets.`
If you don't check this box on the OAuth screen this function won't work.
}
\examples{
\dontrun{

drive_id <- "https://drive.google.com/drive/folders/0AJb5Zemj0AAkUk9PVA"
drive_id <- "https://drive.google.com/drive/u/0/folders/1XWXHHyj32Uw_UyaUJrqp6S--hHnM0-7l"
slido_data <- get_slido_files(drive_id)
}
}
