% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/twin.clustertrunc.r
\name{twin.clustertrunc}
\alias{twin.clustertrunc}
\title{Estimation of twostage model with cluster truncation in bivariate situation}
\usage{
twin.clustertrunc(survformula, data = sys.parent(), theta.des = NULL,
  clusters = NULL, Nit = 10, final.fitting = FALSE, ...)
}
\arguments{
\item{survformula}{Formula with survival model aalen or cox.aalen, some limitiation on model specification due to call of fast.reshape (so for example interactions and * and : do not work here, expand prior to call)}

\item{data}{Data frame}

\item{theta.des}{design for dependence parameters in two-stage model}

\item{clusters}{clustering variable for twins}

\item{Nit}{number of iteration}

\item{final.fitting}{TRUE to do final estimation with SE and ... arguments for marginal models}

\item{...}{Additional arguments to lower level functions}
}
\description{
Estimation of twostage model with cluster truncation in bivariate situation
}
\examples{
data(diabetes)
v <- diabetes$time*runif(nrow(diabetes))*rbinom(nrow(diabetes),1,0.5)
diabetes$v <- v

aout <- twin.clustertrunc(Surv(v,time,status)~1+treat+adult,
			 data=diabetes,clusters="id")
aout$two        ## twostage output
par(mfrow=c(2,2))
plot(aout$marg) ## marginal model output

out <- twin.clustertrunc(Surv(v,time,status)~1+prop(treat)+prop(adult),
			 data=diabetes,clusters="id")
out$two        ## twostage output
plot(out$marg) ## marginal model output
}
\author{
Thomas Scheike
}

