% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof-phreg.R
\name{gofM.phreg}
\alias{gofM.phreg}
\title{GOF for Cox covariates in  PH regression}
\usage{
gofM.phreg(formula, data, offset = NULL, weights = NULL,
  modelmatrix = NULL, n.sim = 1000, silent = 1, ...)
}
\arguments{
\item{formula}{formula for cox regression}

\item{data}{data for model}

\item{offset}{offset}

\item{weights}{weights}

\item{modelmatrix}{matrix for cumulating residuals}

\item{n.sim}{number of simulations for score processes}

\item{silent}{to keep it absolutely silent, otherwise timing estimate will be prduced for longer jobs.}

\item{...}{Additional arguments to lower level funtions}
}
\description{
Cumulative residuals after model matrix for Cox PH regression
p-values based on Lin, Wei, Ying resampling.
}
\examples{
data(TRACE)

dcut(TRACE)  <- ~. 
mm <- model.matrix(~-1+factor(wmicat.4),data=TRACE)
m1 <- gofM.phreg(Surv(time,status==9)~vf+chf+wmi,data=TRACE,modelmatrix=mm) 
summary(m1)
par(mfrow=c(2,2))
plot(m1)

m1 <- gofM.phreg(Surv(time,status==9)~strata(vf)+chf+wmi,data=TRACE,modelmatrix=mm) 
summary(m1)
}
\author{
THomas Scheike and Klaus K. Holst
}
