% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bias.R
\name{gpd.bias}
\alias{gpd.bias}
\title{Cox-Snell first order bias expression for the generalized Pareto distribution}
\usage{
gpd.bias(par, n)
}
\arguments{
\item{par}{vector of \code{scale} and \code{shape}}

\item{n}{sample size}
}
\description{
Bias vector for the GP distribution based on an \code{n} sample.
}
\references{
Coles, S. (2001). \emph{An Introduction to Statistical Modeling of Extreme Values}, Springer, 209 p.

Cox, D. R. and E. J. Snell (1968). A general definition of residuals, \emph{Journal of the Royal Statistical Society: Series B (Methodological)}, \strong{30}, 248--275.

Cordeiro, G. M. and R. Klein (1994). Bias correction in ARMA models, \emph{Statistics and Probability Letters}, \strong{19}(3), 169--176.

Giles, D. E., Feng, H. and R. T. Godwin (2016).  Bias-corrected maximum likelihood estimation of the  parameters of the generalized Pareto distribution, \emph{Communications in Statistics - Theory and Methods}, \strong{45}(8), 2465--2483.
}
\seealso{
\code{\link{gpd}}, \code{\link{gpd.bcor}}
}
\keyword{internal}
