% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univdist.R
\name{rlarg}
\alias{rlarg}
\alias{rlarg.infomat}
\title{Distribution of the r-largest observations}
\usage{
rlarg.infomat(par, dat, method = c("obs", "exp"), nobs = nrow(dat),
  r = ncol(dat))
}
\arguments{
\item{par}{vector of \code{loc}, \code{scale} and \code{shape}}

\item{dat}{an \code{n} by \code{r} sample matrix, ordered from largest to smallest in each row}

\item{method}{string indicating whether to use the expected  (\code{'exp'}) or the observed (\code{'obs'} - the default) information matrix.}

\item{nobs}{number of observations for the expected information matrix. Default to \code{length(dat)} if \code{dat} is provided.}

\item{r}{number of order statistics kept. Default to \code{ncol(dat)}}
}
\description{
Likelihood, score function and information matrix for the r-largest observations likelihood.

The function returns the expected or observed information matrix.
}
\section{Usage}{

\preformatted{
rlarg.ll(par, dat, u, np)
rlarg.score(par, dat)
rlarg.infomat(par, dat, method = c('obs', 'exp'), nobs = nrow(dat), r = ncol(dat))}
}

\section{Functions}{


\itemize{
\item{\code{rlarg.ll}:} {log likelihood}
\item{\code{rlarg.score}:} {score vector}
\item{\code{rlarg.infomat}:} {observed or expected information matrix}
}
}

\references{
Coles, S. (2001). \emph{An Introduction to Statistical Modeling of Extreme Values}, Springer, 209 p.

Smith, R.L. (1986).  Extreme value theory based on the r largest annual events, \emph{Journal of Hydrology}, \bold{86}(1-2), 27--43, \code{http://dx.doi.org/10.1016/0022-1694(86)90004-1}.
}
\seealso{
\code{\link{rlarg}}
}
\author{
Leo Belzile
}
\keyword{internal}
