% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgplikelihoods.R
\name{jac_gpd_pareto}
\alias{jac_gpd_pareto}
\title{Jacobian of the transformation from generalized Pareto to unit Pareto distribution}
\usage{
jac_gpd_pareto(dat, loc = 0, scale, shape, lambdau = 1, censored)
}
\arguments{
\item{dat}{vector or matrix of data}

\item{loc}{vector of location parameters}

\item{scale}{vector of scale parameters, strictly positive}

\item{shape}{shape parameter}

\item{lambdau}{vector of probability of marginal threshold exceedance}

\item{censored}{a matrix of logical indicating whether the observations are censored}
}
\value{
log-likelihood contribution for the Jacobian
}
\description{
If \code{dat} is a vector, the arguments \code{loc}, \code{scale} and \code{shape} should be numericals of length 1.
}
\keyword{internal}
