% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.based.R
\name{mf.model.based}
\alias{mf.model.based}
\alias{mf.model.based.default}
\alias{mf.model.based.formula}
\title{Decision Tree Model Based Meta-features}
\usage{
mf.model.based(...)

\method{mf.model.based}{default}(x, y, features = "all", summary = c("mean",
  "sd"), ...)

\method{mf.model.based}{formula}(formula, data, features = "all",
  summary = c("mean", "sd"), ...)
}
\arguments{
\item{...}{Optional arguments to the summary methods.}

\item{x}{A data.frame contained only the input attributes}

\item{y}{A factor response vector with one label for each row/component of x.}

\item{features}{A list of features names or \code{"all"} to include all them.}

\item{summary}{A list of methods to summarize the results as post-processing
functions. See \link{post.processing} method to more information. (Default:
\code{c("mean", "sd")})}

\item{formula}{A formula to define the class column.}

\item{data}{A data.frame dataset contained the input attributes and class.
The details section describes the valid values for this group.}
}
\value{
Each one of these meta-features generate multiple values (by leaves
 and/or nodes) and then it is post processed by the summary methods.
 See the \link{post.processing} method for more details about it.
}
\description{
Decision Tree (DT) Model Based meta-features are the measures desined to
extract characteristics like the depth, the shape and size of a DT model
induced from a dataset.
}
\details{
The following features are allowed for this method:
 \describe{
   \item{"average.leaf.corrobation"}{Represents the.number of examples that
     belong to each leaf in the DT model divided by the number of examples in
     the dataset.}
   \item{"branch.length"}{Represents the.size of each leaf in the DT model.}
   \item{"depth"}{Represents the size of each path in the DT model.}
   \item{"homogeneity"}{Represents the number of leaves divided by the
     strutural shape of the DT model.}
   \item{"max.depth"}{Represents the size of the longest path of the DT
     model.}
   \item{"nleave"}{Represents the number of leaves of the DT model.}
   \item{"nnode"}{Represents the number of nodes in the DT model.}
   \item{"nodes.per.attribute"}{Represents the number of nodes in the DT
     model divided by the number of predictive attributes.}
   \item{"nodes.per.instance"}{Represents the number of leaves in the DT
     model divided by the number of examples in the dataset.}
   \item{"nodes.level"}{Represents the number of nodes per level.}
   \item{"repeated.nodes"}{Represents the number of repeated attributes that
     appear in the DT model.}
   \item{"shape"}{Represents the probability of arrive in each leaf given a
     random walk. We call this as the strutural shape of the DT model.}
   \item{"variable.importance"}{Represents the variable importance calculated
     by Gini index to construct the DT model.}
 }
}
\examples{
## Extract all meta-features using formula
mf.model.based(Species ~ ., iris)

## Extract all meta-features using data.frame
mf.model.based(iris[1:4], iris[5])

## Extract some meta-features
mf.model.based(Species ~ ., iris, features=c("nnode", "nleave", "depth"))

## Extract all meta-features with different summary methods
mf.model.based(Species ~ ., iris, summary=c("min", "median", "max"))
}
\references{
Bensusan, H., Giraud-Carrier, C. G., & Kennedy, C. J. (2000). A Higher-order
 Approach to Meta-learning. In Proceedings of the 10th International
 Conference on Inductive Logic Programming (Vol. 35, pp. 1-10).

 Peng, Y., Flach, P. A., Soares, C., & Brazdil, P. (2002). Improved Dataset
 Characterisation for Meta-learning. In Proceedings of the 5th International
 Conference on Discovery Science (Vol 2534, pp. 141-152)
}
\seealso{
Other meta.features: \code{\link{mf.discriminant}},
  \code{\link{mf.general}}, \code{\link{mf.infotheo}},
  \code{\link{mf.landmarking}},
  \code{\link{mf.statistical}}
}

