% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrPermutationTests.R
\name{discr.test.one_sample}
\alias{discr.test.one_sample}
\title{Discriminability One Sample Permutation Test}
\usage{
discr.test.one_sample(D, ids, nperm = 100, verbose = FALSE)
}
\arguments{
\item{D}{\code{[n x n]} the distance matrix to run a permutation test for, for \code{n} samples.}

\item{ids}{\code{n} the labels of each of the \code{n} samples, in the same ordering as elements of the distance matrix. Label 1 should correspond to the first column, 2 the second, and so on.}

\item{nperm}{the number of permutations to perform. Defaults to \code{100}.}

\item{verbose}{whether to print the itereation numbers. Defaults to \code{FALSE}.}
}
\value{
A list containing the following:
\item{\code{srel}}{the relative, unpermuted discriminability you want to see is significant.}
\item{\code{null}}{the discriminability scores of the permuted data.}
\item{\code{pval}}{the pvalue associated with the permutation test.}
}
\description{
A function that permutes the labels of a distance matrix to obtain an empirical pvalue associated with whether the raw score is due to random chance.
}
\author{
Shangsi Wang and Eric Bridgeford
}
