% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ALE1D.R
\name{plot.ALE1D}
\alias{plot.ALE1D}
\title{Plot 1D Accumulated Local Effects (ALE)}
\usage{
\method{plot}{ALE1D}(x, trans = identity, maxpo = 10000, nsim = 0, ...)
}
\arguments{
\item{x}{a 1D ALE effects, produced by the \code{ALE} function}

\item{trans}{monotonic function to apply to the ALE effect, before plotting.
Monotonicity is not checked.}

\item{maxpo}{maximum number of rug lines that will be used by \code{l_rug}.
If number of datapoints > \code{maxpo}, then a subsample of \code{maxpo} points will be taken.}

\item{nsim}{number of ALE effect curves to be simulated from the posterior distribution.
These can be plotted using the \link{l_simLine} layer. See Examples section below.}

\item{...}{currently not used.}
}
\value{
An objects of class \code{plotSmooth}.
}
\description{
Plot 1D Accumulated Local Effects (ALE)
}
\examples{

library(mgcViz)
# Here x1 and x2 are very correlated, but only 
# x1 has influence of the response
set.seed(4141)
n <- 1000
X <- rmvn(n, c(0, 0), matrix(c(1, 0.9, 0.9, 1), 2, 2))
y <- X[ , 1] + 0.2 * X[ , 1]^2 + rnorm(n, 0, 0.8)
dat <- data.frame(y = y, x1 = X[ , 1], x2 = X[ , 2])
fit <- gam(y ~ te(x1, x2), data = dat)

# Marginal plot suggests that E(y) depends on x2, but
# this is due to the correlation between x1 and x2...
plot(dat$x2, fit$fitted.values)

# ... in fact ALE effect of x2 is flat ...
plot(ALE(fit, "x2")) + l_ciPoly() + l_fitLine() + l_rug()

# ... while ALE effect of x1 is strong.
plot(ALE(fit, "x1", center = 2), nsim = 20) + 
  l_simLine() + l_fitLine()
  
}
\references{
Apley, D.W., and Zhu, J, 2016. Visualizing the effects of predictor variables in black
box supervised learning models. arXiv preprint arXiv:1612.08468.
}
\author{
Matteo Fasiolo and Christian Capezza, with some internal code having been adapted from the ALEPlot
package of Dan Apley.
}
