\name{smooth.construct.gp.smooth.spec}
\alias{smooth.construct.gp.smooth.spec}
\alias{Predict.matrix.gp.smooth}
\alias{gp.smooth}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Low rank Gaussian process smooths}

\description{Gaussian process/kriging models based on simple covariance functions can be written in a very similar form to thin plate and Duchon spline models (e.g. Handcock, Meier, Nychka, 1994), and low rank versions produced by the eigen approximation method of Wood (2003). Kammann and Wand (2003) suggest a particularly simple form of the Matern covariance function with only a single smoothing parameter to estimate, and this class implements this and other similar models.  

Usually invoked by an \code{s(...,bs="gp")} term in a \code{gam} formula. Argument \code{m} selects the covariance function, sets the range parameter and any power parameter. If \code{m} is not supplied then it defaults to \code{NA} and the covariance function suggested by Kammann and Wand (2003) along with their suggested range parameter is used. Otherwise \code{m[1]} between 1 and 5 selects the correlation function from respectively, spherical, power exponential, and Matern with kappa = 1.5, 2.5 or 3.5. \code{m[2]} if present specifies the range parameter, with non-positive or absent indicating that the Kammann and Wand estimate should be used. \code{m[3]} can be used to specify the power for the power exponential which otherwise defaults to 1. 
}

\usage{
\method{smooth.construct}{gp.smooth.spec}(object, data, knots)
\method{Predict.matrix}{gp.smooth}(object, data)
}

\arguments{ 
\item{object}{a smooth specification object, usually generated by a term \code{s(...,bs="ms",...)}.}

\item{data}{a list containing just the data (including any \code{by} variable) required by this term, 
            with names corresponding to \code{object$term} (and \code{object$by}). The \code{by} variable 
            is the last element.} 

\item{knots}{a list containing any knots supplied for basis setup --- in same order and with same names as \code{data}. 
             Can be \code{NULL}}

}

\value{ An object of class \code{"gp.smooth"}. In addition to the usual elements of a 
smooth class documented under \code{\link{smooth.construct}}, this object will contain:
\item{shift}{A record of the shift applied to each covariate in order to center it around zero and 
avoid any co-linearity problems that might otherwise occur in the penalty null space basis of the term. }
\item{Xu}{A matrix of the unique covariate combinations for this smooth (the basis is constructed by first stripping 
out duplicate locations).}
\item{UZ}{The matrix mapping the smoother parameters back to the parameters of a full GP smooth.}
\item{null.space.dimension}{The dimension of the space of functions that have zero wiggliness according to the wiggliness penalty for this term.}
\item{gp.defn}{the type, range parameter and power parameter defining the correlation function. }
}

\details{ Let \eqn{\rho>0}{r>0} be the range parameter, \eqn{0 < \kappa\le 2 }{0<k<=2} and \eqn{d}{d} denote the distance between two points. Then the correlation functions indexed by \code{m[1]} are:
\enumerate{
\item \eqn{1 - 1.5 d/\rho + 0.5 (d/\rho)^3}{1-1.5d/r+0.5(d/r)^3} if \eqn{d \le \rho}{d<=r} and 0 otherwise.
\item \eqn{\exp(-(d/\rho)^\kappa)}{exp((d/r)^k)}.
\item \eqn{\exp(-d/\rho)(1+d/\rho)}{exp(-d/r)(1+d/r)}.
\item \eqn{\exp(-d/\rho)(1+d/\rho + (d/\rho)^2/3)}{exp(-d/r)(1+d/r + (d/r)^2/3)}.
\item \eqn{\exp(-d/\rho)(1+d/\rho+2(d/\rho)^2/5 + (d/\rho)^3/15)}{exp(-d/r)(1+d/r+2(d/r)^2/4+(d/r)^3/15)}.
}
See Fahrmeir et al. (2013) section 8.1.6, for example. Note that setting \code{r} to too small a value will lead to unpleasant results, as most points become all but independent (especially for the spherical model. Note: Wood 2017, Figure 5.20 right is based on a buggy implementation). 

The default basis dimension for this class is \code{k=M+k.def} where \code{M} is the null space dimension (dimension of unpenalized function space) and \code{k.def} is 10 for dimension 1, 30 for dimension 2 and 100 for higher dimensions. 
This is essentially arbitrary, and should be checked, but as with all penalized regression smoothers, results are statistically 
insensitive to the exact choise, provided it is not so small that it forces oversmoothing (the smoother's 
degrees of freedom are controlled primarily by its smoothing parameter).

The constructor is not normally called directly, but is rather used internally by \code{\link{gam}}. 
To use for basis setup it is recommended to use \code{\link{smooth.construct2}}.  

For these classes the specification \code{object} will contain
information on how to handle large datasets in their \code{xt} field. The default is to randomly
subsample 2000 `knots' from which to produce a reduced rank eigen approximation to the full basis, 
if the number of unique predictor variable combinations in excess of 2000. The default can be
modified via the \code{xt} argument to \code{\link{s}}. This is supplied as a
list with elements \code{max.knots} and \code{seed} containing a number
to use in place of 2000, and the random number seed to use (either can be
missing). Note that the random sampling will not effect the state of R's RNG. 

For these bases \code{knots} has two uses. Firstly, as mentioned already, for large datasets 
the calculation of the \code{tp} basis can be time-consuming. The user can retain most of the advantages of the 
approach by supplying  a reduced set of covariate values from which to obtain the basis - 
typically the number of covariate values used will be substantially 
smaller than the number of data, and substantially larger than the basis dimension, \code{k}. This approach is 
the one taken automatically if the number of unique covariate values (combinations) exceeds \code{max.knots}.
The second possibility is to avoid the eigen-decomposition used to find the spline basis altogether and simply use 
the basis implied by the chosen knots: this will happen if the number of knots supplied matches the 
basis dimension, \code{k}. For a given basis dimension the second option is 
faster, but gives poorer results (and the user must be quite careful in choosing knot locations).


}
\seealso{\code{\link{tprs}}}

\references{

Fahrmeir, L., T. Kneib, S. Lang and B. Marx (2013) Regression, Springer.

Handcock, M. S., K. Meier and D. Nychka (1994) Journal of the American Statistical Association, 89: 401-403

Kammann, E. E. and M.P. Wand (2003) Geoadditive Models. Applied Statistics 52(1):1-18.

Wood, S.N. (2017) Generalized Additive Models: an introduction with R (2nd ed). CRC/Taylor and Francis
}

\author{ Simon N. Wood \email{simon.wood@r-project.org}}

\examples{
require(mgcv)
eg <- gamSim(2,n=200,scale=.05)
attach(eg)
op <- par(mfrow=c(2,2),mar=c(4,4,1,1))
b0 <- gam(y~s(x,z,k=50),data=data)  ## tps
b <- gam(y~s(x,z,bs="gp",k=50),data=data)  ## Matern spline default range
b1 <- gam(y~s(x,z,bs="gp",k=50,m=c(1,.5)),data=data)  ## spherical 

persp(truth$x,truth$z,truth$f,theta=30) ## truth
vis.gam(b0,theta=30)
vis.gam(b,theta=30)
vis.gam(b1,theta=30)

detach(eg)

}
\keyword{models} \keyword{regression}%-- one or more ..


