% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crosswalks.R
\name{update_marker_symbol}
\alias{update_marker_symbol}
\title{Update marker symbols}
\usage{
update_marker_symbol(x, rpt)
}
\arguments{
\item{x}{A character vector of marker symbols to be remapped.}

\item{rpt}{Report data as a \link[tibble:tibble-package]{tibble} offering the
translation table between old (\code{marker_symbol}) and new
(\code{marker_symbol_now}) symbols. Hence, at least, the following two columns
are required because they encode the mapping:
\itemize{
\item \code{marker_symbol}: The symbols to matched against the values of \code{x}.
\item \code{marker_symbol_now}: The new symbols to be returned in case of a match.
}

Almost always, \code{rpt} will take the result of \code{read_report("marker_list1")}.}
}
\value{
A character vector of most up to date symbols.
}
\description{
\code{\link[=update_marker_symbol]{update_marker_symbol()}} remaps old marker symbols to, in-use, most up to
date symbols.
}
\examples{
# Reading only the first 100 markers (for efficiency)
rpt <- read_report("marker_list1", n_max = 100)
head(rpt)

# Note that:
#   - "0610005A07Rik" is a withdrawn symbol, so gets remapped to Gstm7.
#   - "0610005C13Rik" is an official symbol, so stays the same.
#   - "not a symbol" is not an existing symbol in `rpt`, so gets mapped to `NA`.
symbols <- c("0610005A07Rik", "0610005C13Rik", "not a symbol")
update_marker_symbol(x = symbols, rpt = rpt)

}
