% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addGrasp_function.R
\name{addGrasp}
\alias{addGrasp}
\title{Add GWAS data from GRASP to list}
\usage{
addGrasp(mgl, range)
}
\arguments{
\item{mgl}{List; see \code{\link{buildFromNames}}, \code{\link{buildFromRegion}}, or \code{\link{buildFromEnsgs}}}

\item{range}{Number indicating distance upstream of start and downstream of stop that should be used for filtering SNPs.}
}
\description{
\code{addGrasp} returns a list with the nineteenth element as dataframe with GWAS data from the GRASP database \url{grasp.nhlbi.nih.gov/}.
}
\details{
This gives basic information on trait associated variants as reported by the GRASP database for the gene of interest.  It pulls data based on the position (i.e. any SNP that falls between the start and stop position).  Note a wider range can be taken using the \emph{range} flag.
}
\examples{
\dontrun{buildFromRegion(chr = 2, start = 102314000, stop = 103435000) -> myMgl}
\dontrun{myMgl <- addGrasp(myMgl, range = 0)}

}
\seealso{
Other elements: \code{\link{addAei}},
  \code{\link{addAntisense}}, \code{\link{addCisEqtl}},
  \code{\link{addDnase}}, \code{\link{addEnst}},
  \code{\link{addExpression}}, \code{\link{addGo}},
  \code{\link{addGwasCatalog}}, \code{\link{addLoc}},
  \code{\link{addPtv}}, \code{\link{addPubmed}},
  \code{\link{addSqtlAltrans}}, \code{\link{addSqtlSeek}},
  \code{\link{addTransEqtl}}, \code{\link{missNames}}
}

