% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_matW.R
\name{kernel_matW}
\alias{kernel_matW}
\title{kernel_matW
A function that returns a sparse weight matrix based computed with a specified
kernel (gauss,bisq,tcub,epane,rectangle,triangle) considering coordinates
provides in S and a given bandwidth. If NN<nrow(S) only NN firts neighbours are considered.
If Type!='GD' then S should have additional columns and several
kernels and bandwidths should be be specified by the user.}
\usage{
kernel_matW(H,kernels,coord_i,coord_j=NULL,NN,ncolX=1,
Type='GD',adaptive=FALSE,diagnull=TRUE,rowNorm=TRUE,noisland=FALSE)
}
\arguments{
\item{H}{A vector of bandwidths}

\item{kernels}{A vector of kernel types}

\item{coord_i}{A matrix with  variables used in kernel (reference)}

\item{coord_j}{A matrix with  variables used in kernel (neighbors), default NULL (if NULL coord_j=coord_i)}

\item{NN}{Number of spatial Neighbours for kernels computations}

\item{ncolX}{control parameter}

\item{Type}{Type of Genelarized kernel product ('GD' only spatial,'GDC'
spatial + a categorical variable,'GDX' spatial + a continuous variable,
'GDT' spatial + a time index, and other combinations 'GDXXC','GDTX',...)}

\item{adaptive}{A vector of boolean to choose adaptive version for each kernel}

\item{diagnull}{Zero on diagonal, default FALSE}

\item{rowNorm}{A boolean, row normalization of weights, default TRUE}

\item{noisland}{A boolean to avoid isle with no neighbours for non adaptive kernel, default FALSE}
}
\value{
A sparse Matrix of weights (dgCMatrix).
}
\description{
kernel_matW
A function that returns a sparse weight matrix based computed with a specified
kernel (gauss,bisq,tcub,epane,rectangle,triangle) considering coordinates
provides in S and a given bandwidth. If NN<nrow(S) only NN firts neighbours are considered.
If Type!='GD' then S should have additional columns and several
kernels and bandwidths should be be specified by the user.
}
\examples{
\donttest{
 library(mgwrsar)
 ## loading data example
 data(mydata)
 coords=as.matrix(mydata[,c("x","y")])
 ## Creating a spatial weight matrix (sparce dgCMatrix) of 4 nearest neighbors with 0 in diagonal
 W=kernel_matW(H=4,kernels='rectangle',coord_i=coords,NN=4,adaptive=TRUE,diagnull=TRUE,rowNorm=TRUE)
}
}
