% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.mgwrsar.R
\name{predict_mgwrsar}
\alias{predict_mgwrsar}
\title{mgwrsar Model Predictions
predict_mgwrsar is a function for computing predictions of a mgwrsar models. It uses Best Linear Unbiased Predictor for mgwrsar models with spatial autocorrelation.}
\usage{
predict_mgwrsar(model, newdata, newdata_coords, W = NULL, type = "BPN",
h_w = 100,kernel_w = "rectangle",maxobs=4000,beta_proj=FALSE,
method_pred='TP', k_extra = 8)
}
\arguments{
\item{model}{a model of mgwrsar class.}

\item{newdata}{a matrix or data.frame of new data.}

\item{newdata_coords}{a matrix of new coordinates, and eventually other variables if a General Kernel Product is used.}

\item{W}{the spatial weight matrix for models with  spatial autocorrelation.}

\item{type}{Type for BLUP estimator, default "BPN". If NULL use predictions without spatial bias correction.}

\item{h_w}{A bandwidth value for the spatial weight matrix}

\item{kernel_w}{kernel type for the spatial weight matrix. Possible types:
rectangle ("rectangle"), bisquare ("bisq"), tricube ("tcub"),
epanechnikov ("epane"), gaussian ("gauss")) .}

\item{maxobs}{maximum number of observations for exact calculation of solve(I- rho*W), default maxobs=4000.}

\item{beta_proj}{A boolean, if TRUE the function then return a two elements list(Y_predicted,Beta_proj_out)}

\item{method_pred}{If method_pred = 'TP' (default) prediction is done by recomputing a MGWRSAR model
with new-data as target points, else if method_pred in ('tWtp_model','model','sheppard') a matrix
for projecting estimated betas is used (see details).}

\item{k_extra}{number of neighboors for local parameter extrapolation if sheppard kernel is used, default 8.}
}
\value{
A vector of predictions if beta_proj is FALSE or a list with a vector named Y_predicted and a matrix named Beta_proj_out.
}
\description{
mgwrsar Model Predictions
predict_mgwrsar is a function for computing predictions of a mgwrsar models. It uses Best Linear Unbiased Predictor for mgwrsar models with spatial autocorrelation.
}
\details{
if method_pred ='tWtp_model',  the weighting matrix for prediction is
based on the expected weights of outsample data if they were had been added to
insample data to estimate the corresponding MGWRSAR (see Geniaux 2022 for
further detail), if method_pred ='sheppard'a sheppard kernel with k_extra neighbours (default 8) is used and if method_pred='kernel_model' the same kernel
and number of neighbors as for computing the MGWRSAR model is used.
}
\examples{
\donttest{
library(mgwrsar)
 data(mydata)
 coords=as.matrix(mydata[,c("x","y")])
length_out=800
index_in=sample(1:1000,length_out)
index_out=(1:1000)[-index_in]

model_GWR_insample<-MGWRSAR(formula = 'Y_gwr~X1+X2+X3', data = mydata[index_in,],
coords=coords[index_in,],fixed_vars=NULL,kernels=c ('gauss'),H=8, Model = 'GWR',
control=list(adaptive=TRUE))
summary_mgwrsar(model_GWR_insample)

newdata=mydata[index_out,]
newdata_coords=coords[index_out,]
newdata$Y_mgwrsar_1_0_kv=0

Y_pred=predict_mgwrsar(model_GWR_insample, newdata=newdata,
newdata_coords=newdata_coords)
head(Y_pred)
head(mydata$Y_gwr[index_out])
sqrt(mean((mydata$Y_gwr[index_out]-Y_pred)^2)) # RMSE
}
}
\seealso{
MGWRSAR, bandwidths_mgwrsar, summary_mgwrsar, plot_mgwrsar, kernel_matW
}
