\name{mi.completed}
\alias{mi.completed}
\alias{mi.matrix}
\alias{mi.data.frame}
\alias{mi.completed,mi-method}
\alias{mi.matrix,mi-method}
\alias{mi.data.frame,mi-method}

\title{ 
    Multiply Imputed Dataframe or Matrix
}

\description{
    Function to return completed data set from result of mi program.
}
\usage{
mi.completed(object, \dots)
mi.matrix(object, \dots)
mi.data.frame(object, \dots)

\S4method{mi.completed}{mi}( object, m , outcome = c("data.frame", "matrix"))
\S4method{mi.matrix}{mi}( object, m )
\S4method{mi.data.frame}{mi}( object, m )
}
\arguments{
    \item{object}{ mi object containing a multiply imputed data set. 
                        The "mi" object is generated by the mi function.}
    \item{m}{ Index of the imputed data set. The default is 1.}
    \item{outcome}{ If the user wants the outcome in dataframe or matrix.}
    \item{\dots}{other arguments}
}
\value{
    A data set with the missing data imputed.
}
\references{ 
    Andrew Gelman and M. Grazia Pittau,  
    A flexible program for missing-data imputation and model checking, 
    Technical report, Columbia University, New York; 
  Andrew Gelman and Jennifer Hill, 
    Data Analysis Using Regression and Multilevel/Hierarchical Models, 
    Cambridge University Press, 2007.
}

\author{
  Masanao Yajima \email{yajima@stat.columbia.edu},
  M.Grazia Pittau \email{grazia@stat.columbia.edu},
  Andrew Gelman \email{gelman@stat.columbia.edu}
}
\seealso{
    \code{\link{mi}}
}
\examples{
    data(CHAIN)
    imp <- mi (CHAIN, n.iter=6)
    imputed.matrix <- mi.completed (imp) #Imputed dataframe from the 1th Imputation (m=NULL, default=1)
    imputed.matrix <- mi.completed (imp, m=2)  #Imputed dataframe from the 2nd Imputation (m=2)
    imputed.matrix <- mi.completed (imp, m=3, outcome = "matrix")  #Imputed matrix from the 3nd Imputation (m=3)
}
\keyword{ models }
