% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef_wqs_helper.R
\name{coef.wqs}
\alias{coef.wqs}
\title{Finding WQS Coefficients}
\usage{
\method{coef}{wqs}(object, ...)
}
\arguments{
\item{object}{Object of class WQS, which is output using \code{estimate.wqs}. Or object from class
miWQS, which is an output using \code{pool.wqs}.}

\item{...}{Arguments passed on to \code{stats::coef}
\describe{
  \item{}{}
}}
}
\description{
An accessor function that returns the coefficients from the validation WQS model,
a glm2 object.
}
\examples{
#Use simulated dataset and set seed for reproducibility.
data(simdata87)
set.seed(23456)
Wa <- estimate.wqs( y = simdata87$y.scenario, X = simdata87$X.true,
                  B = 10, family = "binomial")
coef(Wa)
}
\seealso{
\code{\link[stats]{coef}}

Other wqs: \code{\link{estimate.wqs}},
  \code{\link{make.quantile.matrix}},
  \code{\link{plot.wqs}}, \code{\link{print.wqs}}
}
\concept{wqs}
\keyword{wqs}
