\name{mira}
\alias{mira}
\alias{print.mira}
\alias{summary.mira}
\title{Multiply Imputed Repeated Analyses}
\usage{
\method{print}{mira}(x, \dots)
\method{summary}{mira}(object, correlation, \dots)
}

\arguments{
    \item{x, object}{An object containing the \code{m} fit objects of a complete data analysis, 
        plus some additional information.}
    \item{correlation}{}
    \item{\dots}{not used}
}
\description{
  The \code{mira} object is generated by the \code{with.mids()}, \code{lm.mids()} and \code{glm.mids()} 
  functions.
  The \code{mira} class of objects has methods for the following generic functions:
  \code{print}, \code{summary}.}

\value{
  \item{call}{  The call that created the object.}
  \item{call1}{ The call that created the \code{mids} object that was used in \code{call}.}
  \item{nmis}{  An array containing the number of missing observations per column.}
  \item{analyses}{ A list of \code{m} components containing the individual fit objects from each of the \code{m} complete data analyses.}
}

\references{
Van Buuren, S., Groothuis-Oudshoorn, K. (2009) 
MICE: Multivariate Imputation by Chained Equations in R. 
\emph{Journal of Statistical Software}, forthcoming.
\url{http://www.stefvanbuuren.nl/publications/MICE in R - Draft.pdf}
}
\author{Stef van Buuren, Karin Groothuis-Oudshoorn, 2000}     
\keyword{classes}  

\seealso{\code{\link{with.mids}}, \code{\link{mids}}, \code{\link{mipo}}}
