% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictorMatrix.R
\name{make.predictorMatrix}
\alias{make.predictorMatrix}
\title{Creates a \code{predictorMatrix} argument}
\usage{
make.predictorMatrix(data, blocks = make.blocks(data))
}
\arguments{
\item{data}{A \code{data.frame} with the source data}

\item{blocks}{An optional specification for blocks of variables in
the rows. The default assigns each variable in its own block.}
}
\value{
A matrix
}
\description{
This helper function creates a valid \code{predictMatrix}. The
\code{predictorMatrix} is an argument to the \code{mice} function.
It specifies the target variable or block in the rows, and the
predictor variables on the columns. An entry of \code{0} means that
the column variable is NOT used to impute the row variable or block.
A nonzero value indicates that it is used.
}
\examples{
make.predictorMatrix(nhanes)
make.predictorMatrix(nhanes, blocks = make.blocks(nhanes, "collect"))
}
\seealso{
\code{\link{make.blocks}}
}
