#'miceExt: Extension Package to mice
#'
#'This package extends and builds on the \code{\link[mice]{mice}} package by
#'adding a functionality to perform multivariate predictive mean matching on
#'imputed data as well as new functionalities to perform predictive mean
#'matching on factor variables.
#'
#'@details
#'The \code{\link[mice]{mice}} package, which was implemented and published by
#'Stef van Buuren and Karin Groothuis-Oudshoorn in 2001 and has been further
#'developed ever since, is one of most extensive and most commonly used
#'implementations of multiple imputation within R. Despite its many years of
#'refinement however, there are still some missing data problems that mice does
#'not handle very well, and two of these have now been addressed within the
#'implementation of this package.\cr
#'First, mice does not provide any option to perform imputation on multiple
#'columns at once, which can, for instance, result in nonsensical output
#'imputations when there are causal relationships between the corresponding
#'attributes, e.g. a 15-year-old person that has a driver's license. \cr
#'Further, mice still struggles with imputing categorical data, as many
#'internally used imputation methods either are not suited for this kind of data
#'at all or do not necessarily converge to the optimal solution. \cr
#'Overall, \code{miceExt} provides three functions, namely
#'\enumerate{
#'\item \code{mice.post.matching()},
#'\item \code{mice.binarize()},
#'\item \code{mice.factorize()},
#'}
#'out of which the first function post-processes results of the
#'\code{mice()}-algorithm by performing multivariate predictive mean matching on
#'a user-defined set of column tuples, and results in imputations that are
#'always equal to already-observed values, which annihilates the chance of
#'getting unrealistic output values. \cr The latter two functions tackle the
#'second issue by even extending the functionality of
#'\code{mice.post.matching()}. The function \code{mice.binarize()} transforms
#'categorical attributes of a given data frame into a binary dummy
#'representation, which results in an exclusively numerical data set that mice
#'can handle well. Inconsistencies within the imputed dummy columns can then be
#'handled by \code{mice.post.matching()}, and \code{mice.factorize()} finally
#'serves the purpose of retransforming the imputed binary data into the
#'corresponding original categories, resulting in a proper imputation of the
#'given categorical data.
#'
#'@author Tobias Schumacher, Philipp Gaffert, Stef van Buuren, Karin Groothuis-Oudshoorn
#'
#'@import mice
#'@import stats
#'
#'@seealso \code{\link{mice.post.matching}}, \code{\link{mice.binarize}},
#'  \code{\link{mice.factorize}}, \code{\link[mice]{mice}}
#'
#'@docType package
#'@name miceExt
NULL
