% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naive_fill_NA.R
\name{naive_fill_NA}
\alias{naive_fill_NA}
\alias{naive_fill_NA.data.frame}
\alias{naive_fill_NA.matrix}
\title{\code{naive_fill_NA} function for the imputations purpose.}
\usage{
naive_fill_NA(x)

\method{naive_fill_NA}{data.frame}(x)

\method{naive_fill_NA}{matrix}(x)
}
\arguments{
\item{x}{a numeric matrix or data.frame/data.table (factor/character/numeric/logical)  - variables}
}
\value{
load imputations in a similar to the input type
}
\description{
Regular imputations to fill the missing data.
Non missing independent variables are used to approximate a missing observations for a dependent variable.
For numeric columns with any missing data a simple bayesian mean will be used.
Next all numeric variables will be utilized to impute character/factoer variables by Linear Discriminant Analysis.
}
\section{Methods (by class)}{
\itemize{
\item \code{data.frame}: S3 method for data.frame

\item \code{matrix}: S3 method for matrix
}}

\note{
this is a very simple and fast solution but not recommended, for more complex solutions check the vignette
}
\examples{
\dontrun{
library(naive_fill_NAast)
data(air_miss)
naive_fill_NA(air_miss)
}

}
\seealso{
\code{\link{fill_NA}} \code{\link{fill_NA_N}}  \code{\link{VIF}}
}
