% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool_propdiff_wald.R
\name{pool_propdiff_wald}
\alias{pool_propdiff_wald}
\title{Calculates the pooled difference between proportions and standard error
according to Wald across multiply imputed datasets.}
\usage{
pool_propdiff_wald(object, conf.level = 0.95, dfcom = NULL)
}
\arguments{
\item{object}{An object of class 'mistats' ('Multiply Imputed
Statistical Analysis').}

\item{conf.level}{Confidence level of the confidence intervals.}

\item{dfcom}{Complete data degrees of freedom. Default
number is taken from function \code{propdiff_wald}}
}
\value{
The proportion, the Confidence intervals,
the standard error and statistic.
}
\description{
\code{pool_propdiff_wald} Calculates the pooled difference between proportions
and standard error according to Wald across multiply imputed datasets.
}
\examples{

imp_dat <- df2milist(lbpmilr, impvar="Impnr")
ra <- with(imp_dat, expr=propdiff_wald(Chronic ~ Gender))
res <- pool_propdiff_wald(ra)
res

}
\seealso{
\code{\link{with.milist}}, \code{\link{propdiff_wald}}
}
\author{
Martijn Heymans, 2021
}
