% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growthLimFuncDefault.R
\name{growthLimFuncDefault}
\alias{growthLimFunc}
\alias{growthLimFuncDefault}
\title{growth rate limitation function}
\usage{
growthLimFuncDefault(strainName, groupName, pathName, varName, resourceValues,
  allSubType, strainHalfSat, stateVarValues)
}
\arguments{
\item{strainName}{Name of the strain that is being looped through in the ODE solver}

\item{groupName}{Name of microbial group that is being looped through in the ODE solver}

\item{pathName}{Name of metabolic path (e.g. path1) that is being looped through in the ODE solver}

\item{varName}{(string) Name of variable (resource) of interest}

\item{resourceValues}{State vector of resources  (with names)}

\item{allSubType}{Vector of strings (with names corresponding to the resourceNames) which describes the type of each resource ('Rtype') - Rtypes are S (substitutable resource), Se (essential resource), Sb (booster resource), Sm (microbial resource), P (product) and Pb (biomass product)}

\item{strainHalfSat}{Vector (with names corresponding to the resourceNames) of half-saturation constants for the given strain. If resource is not a substrate for the given strain, the value is NA}

\item{stateVarValues}{State vector (resources and microbes) (with names)}
}
\value{
scalar giving limitation on growth rate - must be >=0 and <=1
}
\description{
Returns the value of growthLim (must lie in interval [0,1] i.e. unitless) of strainName on varName which is used to scale the maximum growth rate
Contains two options - one for essential resources and one for substitutable resources (based on Ballyk and Wolkowicz, 1993)
}

