% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uptakeFuncDefault.R
\name{uptakeFuncDefault}
\alias{uptakeFunc}
\alias{uptakeFuncDefault}
\title{Uptake Function}
\usage{
uptakeFuncDefault(strainName, groupName, pathName, varName, keyResName, subst,
  ess, boost, maxGrowthRate, growthLim, yield, nonBoostFrac, stoichiom, parms)
}
\arguments{
\item{strainName}{Name of the strain that is being looped through in the ODE solver}

\item{groupName}{Name of microbial group that is being looped through in the ODE solver}

\item{pathName}{Name of metabolic path (e.g. path1) that is being looped through in the ODE solver}

\item{varName}{(string). Calculate uptake of this variable}

\item{keyResName}{(string). Name of the key resource on this pathway}

\item{subst}{Vector of strings giving the names of the substitutable resources  for given strain, pathway}

\item{ess}{Vector of strings giving the names of the essential resources  for given strain, pathway}

\item{boost}{Vector of strings giving the names of the boosting resources  for given strain, pathway}

\item{maxGrowthRate}{Vector containing maximum growth rate on each resource (named by resourceNames). If a resource is not on the pathway the value is NA}

\item{growthLim}{Vector containing the growth limitation from each resource (named by resourceNames). If a resource is not on the pathway the value is NA}

\item{yield}{Named vector (names are resourceNames) giving the mass yield of biomass on each resource (mass microbe/mass resource)}

\item{nonBoostFrac}{(scalar) Fraction of max growth achievable if boosting resource is not present but is required on this pathway}

\item{stoichiom}{Named vector (names are resourceNames) giving the mass of each resource in the stoichiometry i.e. molar mass of resource multiplied by the number of moles in the stoichiometry}

\item{parms}{List containing all system parameters}
}
\value{
(scalar) uptake of resource per mass unit of biomass (units are resource mass/biomass/time)
}
\description{
Return the value of resource uptake per biomass (i.e. resource quantity per unit time per mass unit of biomass) for given resource
}

