% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractor.R
\name{getDomain}
\alias{getClass}
\alias{getDomain}
\alias{getFamily}
\alias{getGenus}
\alias{getOrder}
\alias{getPhylum}
\alias{getTag}
\alias{getTaxonomy}
\title{Extractor functions for ConTax data}
\usage{
getDomain(header)
getPhylum(header)
getClass(header)
getOrder(header)
getFamily(header)
getGenus(header)
getTag(header)
getTaxonomy(header)
}
\arguments{
\item{header}{A vector of texts, typically the \code{Header} from a \code{\link[microseq]{Fasta}} object,
containing taxonomy information in the proper format.}
}
\value{
A vector containing the sub-texts extracted from each \code{header} text.
}
\description{
Extracting taxonomic information from ConTax data sets.
}
\details{
The ConTax data sets are \code{\link{Fasta}} objects, where the \code{Header} line follows
a strict format.

The Header always starts with a short text, a Tag, which is a unique identifier for every sequence.
The function \code{getTag} will extract this from the \code{header}.

After the Tag follows one or more tokens. One of these tokens must be a string with the following format:

"k__<...>;p__<...>;c__<...>;o__<...>;f__<...>;g__<...>;"

where <...> is some proper text. Here is an example of a proper string:

"k__Bacteria;p__Firmicutes;c__Bacilli;o__Bacillales;f__Staphylococcaceae;g__Staphylococcus;"

The functions \code{getDomain}, ..., \code{getGenus} extract the
corresponding information from the \code{header}. \code{getTaxonomy}
combines all taxonomy extractors, combines these in a data.frame
and imputes missing taxa with parent taxa.
}
\examples{
data(contax.trim)
getTag(contax.trim$Header)
getGenus(contax.trim$Header)
getPhylum(contax.trim$Header)

}
\author{
Lars Snipen.
}
\seealso{
\code{\link{contax.trim}}, \code{\link{medoids}}.
}

