% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genusLookup.R
\name{genusLookup}
\alias{genusLookup}
\title{Taxonomy lookup}
\usage{
genusLookup(genera, rank = "Phylum")
}
\arguments{
\item{genera}{A vector of texts, the genera names to look up.}

\item{rank}{A single text, the level of the taxonomy to look up.}
}
\value{
A character vector containing the taxonomy information. Names in \code{genera} not recognized will 
return \code{NA}. Please note that there are some cases of un-assigned taxonomy at some ranks 
(Class, Order or Family), this is returned as "unknown".
}
\description{
Extracting taxonomic information from the \code{\link{taxonomy.table}}.
}
\details{
Function for looking up higher-level taxonomy of specified genera.

The argument \code{genera} must consist of names in the \code{Genus} column of the data
set \code{\link{taxonomy.table}}.
}
\examples{
genus <-  c("Acidilobus","Nitrosopumilus","Hyphomonas") 
genusLookup(genus, rank = "Phylum")
genusLookup(genus, rank = "Class")


}
\seealso{
\code{\link{taxonomy.table}}.
}
\author{
Hilde Vinje, Lars Snipen.
}
