% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_device.R
\name{query_fronius_device}
\alias{query_fronius_device}
\title{Fronius single device query}
\usage{
query_fronius_device(
  device_ip = "fronius.local",
  query,
  username = Sys.getenv("FRONIUS_USERNAME"),
  password = Sys.getenv("FRONIUS_PASSWORD")
)
}
\arguments{
\item{device_ip}{IP address or name of the device}

\item{query}{the API query string}

\item{username}{the username needed to authenticate to the inverter.
Defaults to the `FRONIUS_USERNAME` environment variable.}

\item{password}{the password needed to authenticate to the inverter.
Defaults to the `FRONIUS_PASSWORD` environment variable.}
}
\value{
a data-frame with a `device_id` column and the `$Body$Data` turned into
   as many columns as expected
}
\description{
as a port of https://github.com/friissoren/pyfronius
}
\examples{
\dontrun{
query_fronius_device(query = "GetInverterRealtimeData.cgi?Scope=System")
}
}
\seealso{
Other device queries: 
\code{\link{query_ap_device}()},
\code{\link{query_ap_devices}()},
\code{\link{query_enphaseenergy_device}()},
\code{\link{query_enphaseenvoy_device}()},
\code{\link{query_fronius_devices}()}
}
\concept{device queries}
