% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panpca.R
\name{plot.Panpca}
\alias{plot.Panpca}
\alias{summary.Panpca}
\title{Plot and summary of \code{Panpca} objects}
\usage{
\method{plot}{Panpca}(x, cum = FALSE, col = "black", ...)

\method{summary}{Panpca}(object, ...)
}
\arguments{
\item{x}{A \code{Panpca} object, see below.}

\item{cum}{Logical, default is \samp{FALSE}, indicating if explained variance should be plotted
per component or cumulative.}

\item{col}{Color, default is \samp{"black"}, of interior and border of bars in the barplot.}

\item{\dots}{Optional graphical arguments.}

\item{object}{A \code{Panpca} object, see below.}
}
\description{
Generic functions for \code{Panpca} objects.
}
\details{
A \code{Panpca} object contains the results from a principal component analysis (PCA) on
a pan-matrix, and is the output from the function \code{\link{panpca}}. It is a small (S3) extension
of a \code{list}, and contains the elements \samp{Evar}, \samp{Scores}, \samp{Loadings}, \samp{Scale}
and \samp{Weights}.

The basic idea of a PCA is to find alternative directions in the space spanned by the pan-matrix
columns, in order to be able to visualize or in other ways extract the most relevant information in
a small number of dimensions. The variable \samp{Evar} contains the explained variance for each
principal component, scaled such that summed over all components it is 1.0. This quantity indicates
the importance of each component, larger values of \samp{Evar} indicates directions (components) with
more information.

The \code{\link{plot.Panpca}} function shows the \samp{Evar} values in a barplot. You can either plot
the \samp{Evar} value of each component separately (\samp{cum=FALSE}) or the cumulative value
(\samp{cum=TRUE}). This is the basic plot to follow any principal component decomposition, since it
tells you how many components you need to capture the bulk of the information in the data. If e.g.
component 1, 2 and 3 have \samp{Evar} values of 0.4, 0.3 and 0.2, respectively, it means these three
direction capture 90\% (0.4+0.3+0.2=0.9) of all the variation in the data. For some pan-matrices almost
all variation can be found in the very few first directions, but more often it is scattered between many.
See \code{\link{plotScores}} and \code{\link{plotLoadings}} for other informative graphical displays of
a \code{Panpca} object.

The \code{\link{summary.Panpca}} function will print the same information as plotted by
\code{\link{plot.Panpca}}.
}
\examples{
# See examples in the Help-file for panpca.

}
\seealso{
\code{\link{panpca}}, \code{\link{plotScores}}, \code{\link{plotLoadings}}.
}
\author{
Lars Snipen and Kristian Hovde Liland.
}
