% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gff.R
\name{gff2fasta}
\alias{gff2fasta}
\title{Retrieving sequences from genome}
\usage{
gff2fasta(gff.table, genome)
}
\arguments{
\item{gff.table}{A \code{gff.table} (\code{data.frame}) with genomic features information.}

\item{genome}{A \code{\link{Fasta}} object with the genome sequence(s).}
}
\value{
A \code{\link{Fasta}} object with one row for each row in \code{gff.table}. 
The \code{Header} for each sequence is a summary of the information in the
corresponding row of \code{gff.table}.
}
\description{
Retrieving the sequences specified in a \code{gff.table}.
}
\details{
Each row in \code{gff.table} (see \code{\link{readGFF}}) describes a genomic feature
in the \code{genome}. The information in the columns Seqid, Start, End and Strand are used to retrieve
the sequences from \code{genome$Sequence}. Every Seqid in the \code{gff.table}
must match the first token in one of the \code{genome$Header} texts.
}
\examples{
# Using two files in this package
xpth <- file.path(path.package("micropan"),"extdata")
gff.file <- file.path(xpth,"Example.gff.xz")
genome.file <- file.path(xpth,"Example_genome.fasta.xz")

# We need to uncompress them first...
gff.tf <- tempfile(fileext=".xz")
s <- file.copy(gff.file,gff.tf)
gff.tf <- xzuncompress(gff.tf)
genome.tf <- tempfile(fileext=".xz")
s <- file.copy(genome.file,genome.tf)
genome.tf <- xzuncompress(genome.tf)

# Reading
gff.table <- readGFF(gff.tf)
genome <- readFasta(genome.tf)

# Retrieving sequences
fasta.obj <- gff2fasta(gff.table,genome)
summary(fasta.obj)
plot(fasta.obj)

# ...and cleaning...
s <- file.remove(gff.tf,genome.tf)

}
\seealso{
\code{\link{readGFF}}, \code{\link{findOrfs}}.
}
\author{
Lars Snipen and Kristian Hovde Liland.
}
