% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{fin_reform}
\alias{fin_reform}
\title{Political economy of financial reforms}
\format{
a tibble containing:
\itemize{
\item country: the country id
\item year: the year
\item region: the region
\item pol: political orientation of the government
\item fli: degree of policy liberalization index (from 0 to 18)
\item yofc: year of office
\item gdpg: growth rate of the gdp
\item infl: inflation rate
\item bop: balance of payments crises
\item bank: banking crises
\item imf: IMF program dummy
\item usint: international interest rates
\item open: trade openess
\item dindx: difference of the inflation rate
\item indx: inflation rate divided by 18
\item indxl: lag value of indx
\item rhs1: indxl * (1 - indxl)
\item max_indxl: maximumum value of indxl by year and region
\item catchup: difference between max_indxl and indxl
\item dum_bop: balance of paiement crisis in the first two previous years
\item dum_bank: bank crises in the first two previous years
\item dum_1yofc: dummy for first year of office
\item recession: dummy for recessions
\item hinfl: dummy for inflation rate greater than 50 percent
}
}
\source{
AEA website
}
\description{
a pseudo-panel of 35 countries from 1973 to 1996
}
\references{
\insertRef{ABIA:MODY:05}{micsr}
}
\keyword{dataset}
