% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cpp_sgl_fit}
\alias{cpp_sgl_fit}
\title{Computes a single solution for \eqn{\lambda_1} and \eqn{\lambda_2} values}
\usage{
cpp_sgl_fit(
  beta0,
  Z,
  X,
  y,
  index,
  lambda1,
  lambda2,
  innerIter,
  outerIter,
  thresh,
  outerThresh,
  gamma_solver,
  step,
  reset
)
}
\arguments{
\item{beta0}{(vec) vector of initial \eqn{\beta_0} regression coefficients.}

\item{Z}{(mat) matrix of dummies.}

\item{X}{(mat) matrix of covariates.}

\item{y}{(vec) vector of response.}

\item{index}{(vec) vector indicating group membership of each covariate.}

\item{lambda1}{(vec) single value of \eqn{\lambda_1}.}

\item{lambda2}{(vec) single value of \eqn{\lambda_2}.}

\item{innerIter}{(int) max number of inner iterations.}

\item{outerIter}{(int) max number of outer iterations.}

\item{thresh}{(double) convergence threshold of inner loop.}

\item{outerThresh}{(double) convergence threshold of outer loop.}

\item{gamma_solver}{(double) solver parameter.}

\item{step}{(double) solver parameter.}

\item{reset}{(int) solver parameter.}
}
\description{
Computes a single solution for \eqn{\lambda_1} and \eqn{\lambda_2} values
}
\keyword{internal}
