% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate.midas_r}
\alias{simulate}
\alias{simulate.midas_r}
\title{Simulate MIDAS regression response}
\usage{
\method{simulate}{midas_r}(object, nsim = 999, seed = NULL, future = TRUE,
  newdata = NULL, insample = NULL, method = c("static", "dynamic"),
  innov = NULL, show_progress = TRUE, ...)
}
\arguments{
\item{object}{\code{\link{midas_r}} object}

\item{nsim}{number of simulations}

\item{seed}{either NULL or an integer that will be used in a call to set.seed before simulating the time series. The default, NULL will not change the random generator state.}

\item{future}{logical, if \code{TRUE} forecasts are simulated, if \code{FALSE} in-sample simulation is performed.}

\item{newdata}{a named list containing future values of mixed frequency regressors.  The default is \code{NULL}, meaning that only in-sample data is used.}

\item{insample}{a list containing the historic mixed frequency data}

\item{method}{the simulation method, if \code{"static"} in-sample values for dependent variable are used in autoregressive MIDAS model, if \code{"dynamic"}
the dependent variable values are calculated step-by-step from the initial in-sample values.}

\item{innov}{a matrix containing the simulated innovations. The default is \code{NULL}, meaning, that innovations are simulated from model residuals.}

\item{show_progress}{logical, TRUE to show progress bar, FALSE for silent evaluation}

\item{...}{not used currently}
}
\value{
a matrix of simulated responses. Each row contains a simulated response.
}
\description{
Simulates one or more responses from the distribution corresponding to a fitted MIDAS regression object.
}
\details{
Only the regression innovations are simulated, it is assumed that the predictor variables and coefficients are fixed. The
innovation distribution is simulated via bootstrap.
}
\examples{
data("USrealgdp")
data("USunempr")

y <- diff(log(USrealgdp))
x <- window(diff(USunempr), start = 1949)
trend <- 1:length(y)

##24 high frequency lags of x included
mr <- midas_r(y ~ trend + fmls(x, 23, 12, nealmon), start = list(x = rep(0, 3)))

simulate(mr, nsim=10, future=FALSE)

##Forecast horizon
h <- 3
##Declining unemployment
xn <- rep(-0.1, 12*3)
##New trend values
trendn <- length(y) + 1:h

simulate(mr, nsim = 10, future = TRUE, newdata = list(trend = trendn, x = xn))
}
\author{
Virmantas Kvedaras, Vaidotas Zemlys
}

