% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mid.R
\name{plot.mid}
\alias{plot.mid}
\title{Plot MID with graphics Package}
\usage{
\method{plot}{mid}(
  x,
  term,
  type = c("effect", "data", "compound"),
  theme = NULL,
  intercept = FALSE,
  main.effects = FALSE,
  data = NULL,
  jitter = 0.3,
  cells.count = c(100L, 100L),
  limits = NULL,
  ...
)
}
\arguments{
\item{x}{a "mid" object to be visualized.}

\item{term}{a character string specifying the component function to be plotted.}

\item{type}{character string.}

\item{theme}{a character vector of color names or a character string specifying the color theme.}

\item{intercept}{logical. If \code{TRUE}, the intercept is added to the MID values and the plotting scale is shifted.}

\item{main.effects}{logical. If \code{TRUE}, the main effects are included in the interaction plot.}

\item{data}{a data.frame to be plotted with the corresponding MID values. If not passed, data is extracted from \code{parent.env()} based on the function call of the "mid" object.}

\item{jitter}{a numeric value specifying the amount of jitter for points.}

\item{cells.count}{an integer or integer-valued vector of length two specifying the number of cells for the raster type interaction plot.}

\item{limits}{\code{NULL} or a numeric vector of length two specifying the limits of the plotting scale. \code{NA}s are replaced by the minimum and/or maximum MID values.}

\item{...}{optional parameters to be passed to the graphing function. Possible arguments are "col", "fill", "pch", "cex", "lty", "lwd" and aliases of them.}
}
\value{
\code{plot.mid()} produces a line plot or bar plot for a main effect and a filled contour plot for an interaction and returns \code{NULL}.
}
\description{
For "mid" objects, \code{plot()} visualizes a MID component function.
}
\details{
The S3 method of \code{plot()} for "mid" objects creates a visualization of a MID component function using the functions of the graphics package.
}
\examples{
data(diamonds, package = "ggplot2")
set.seed(42)
idx <- sample(nrow(diamonds), 1e4)
mid <- interpret(price ~ (carat + cut + color + clarity)^2, diamonds[idx, ])
plot(mid, "carat")
plot(mid, "clarity")
plot(mid, "carat:clarity", main.effects = TRUE)
plot(mid, "clarity:color", type = "data", theme = "Mako", data = diamonds[idx, ])
plot(mid, "carat:color", type = "compound", data = diamonds[idx, ])
}
