% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_mid.R
\name{print.mid}
\alias{print.mid}
\title{Print MID Models}
\usage{
\method{print}{mid}(x, digits = max(3L, getOption("digits") - 2L), main.effects = FALSE, ...)
}
\arguments{
\item{x}{a "mid" object to be printed.}

\item{digits}{an integer specifying the number of significant digits.}

\item{main.effects}{logical. If \code{TRUE}, MID values of the main effects are printed.}

\item{...}{not used.}
}
\value{
\code{print.mid()} returns the "mid" object passed to the function without any modification.
}
\description{
For "mid" objects, \code{print()} prints the MID values and the uninterpreted rate.
}
\details{
The S3 method of \code{print()} for "mid" objects prints the MID values of a fitted MID model and its uninterpreted rate.
}
\examples{
data(cars, package = "datasets")
print(interpret(dist ~ speed, cars))
}
