% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SelectorTournament.R
\name{dict_selectors_tournament}
\alias{dict_selectors_tournament}
\alias{SelectorTournament}
\title{Tournament Selector}
\description{
\code{\link{Selector}} that repeatedly samples \code{k} individuals and selects the best ouf of these.
}
\section{Configuration Parameters}{

\itemize{
\item \code{k} :: \code{integer(1)}\cr
Tournament size. Must be set by the user.
\item \code{choose_per_tournament} :: Number of individuals to choose in each tournament. Must be smaller than \code{k}. The special value \code{0} sets this to the \code{group_size}
hint given to the \verb{$operate()}-call (but at most \code{k}). This is equal to \code{n_select} when used as survival-selector in \code{\link[=mies_survival_plus]{mies_survival_plus()}}/\code{\link[=mies_survival_comma]{mies_survival_comma()}},
and equal to \code{n_indivs_in} of a \code{\link{Recombinator}} used in \code{\link[=mies_generate_offspring]{mies_generate_offspring()}}.\cr
Initialized to 1.
\item \code{sample_unique} :: \code{character(1)}\cr
Whether to sample individuals globally unique (\code{"global"}, selected individuals are removed from the population after each tournament),
unique within groups (\code{"groups"}, individuals are replaced when \code{group_size} individuals were sampled), unique per tournament (\code{"tournament"}, individuals are replaced
after each tournament), or not unique at all (\code{"no"}, individuals are sampled with replacement within tournaments).
This is done with best effort; if \code{group_size} (when \code{sample_unique} is \code{"groups"}) or \code{n_select} (when \code{sample_unique} is \code{"global"})
is greater than \code{nrow(values)}, then the first \code{nrow(values) * floor(group_size / nrow(values))} or \code{nrow(values) * floor(n_select / nrow(values))} individuals
are chosen deterministically by selecting every individual with the same frequency, followed by tournament selection for the remaining required individuals.
Initialized to \code{"groups"}.
}
}

\section{Supported Operand Types}{


Supported \code{\link[paradox:Param]{Param}} classes are: \code{\link[paradox:ParamLgl]{ParamLgl}}, \code{\link[paradox:ParamInt]{ParamInt}}, \code{\link[paradox:ParamDbl]{ParamDbl}}, \code{\link[paradox:ParamFct]{ParamFct}}
}

\section{Dictionary}{

This \code{\link{Selector}} can be created with the short access form \code{\link[=sel]{sel()}}
(\code{\link[=sels]{sels()}} to get a list), or through the the \link[mlr3misc:Dictionary]{dictionary}
\code{\link{dict_selectors}} in the following way:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# preferred:
sel("tournament")
sels("tournament")  # takes vector IDs, returns list of Selectors

# long form:
dict_selectors$get("tournament")
}\if{html}{\out{</div>}}
}

\examples{
sb = sel("tournament", k = 4)
p = ps(x = p_dbl(-5, 5))
# dummy data; note that SelectorBest does not depend on data content
data = data.frame(x = rep(0, 7))
fitnesses = c(1, 5, 2, 3, 0, 4, 6)

sb$prime(p)

sb$operate(data, fitnesses, 2)

sb$operate(data, fitnesses, 4, group_size = 2)
}
\seealso{
Other selectors: 
\code{\link{SelectorScalar}},
\code{\link{Selector}},
\code{\link{dict_selectors_best}},
\code{\link{dict_selectors_maybe}},
\code{\link{dict_selectors_null}},
\code{\link{dict_selectors_proxy}},
\code{\link{dict_selectors_random}},
\code{\link{dict_selectors_sequential}}
}
\concept{selectors}
\section{Super classes}{
\code{\link[miesmuschel:MiesOperator]{miesmuschel::MiesOperator}} -> \code{\link[miesmuschel:Selector]{miesmuschel::Selector}} -> \code{\link[miesmuschel:SelectorScalar]{miesmuschel::SelectorScalar}} -> \code{SelectorTournament}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SelectorTournament-new}{\code{SelectorTournament$new()}}
\item \href{#method-SelectorTournament-clone}{\code{SelectorTournament$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="help"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-help'><code>miesmuschel::MiesOperator$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="operate"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-operate'><code>miesmuschel::MiesOperator$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="print"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-print'><code>miesmuschel::MiesOperator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="repr"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-repr'><code>miesmuschel::MiesOperator$repr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="SelectorScalar" data-id="prime"><a href='../../miesmuschel/html/SelectorScalar.html#method-SelectorScalar-prime'><code>miesmuschel::SelectorScalar$prime()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SelectorTournament-new"></a>}}
\if{latex}{\out{\hypertarget{method-SelectorTournament-new}{}}}
\subsection{Method \code{new()}}{
Initialize the \code{SelectorTournament} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SelectorTournament$new(scalor = ScalorSingleObjective$new())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{scalor}}{(\code{\link{Scalor}})\cr
\code{\link{Scalor}} to use to generate scalar values from multiple objectives, if multi-objective optimization is performed.
Initialized to \code{\link{ScalorSingleObjective}}: Doing single-objective optimization normally, throwing an error if used
in multi-objective setting: In that case, a \code{\link{Scalor}} needs to be explicitly chosen.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SelectorTournament-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SelectorTournament-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SelectorTournament$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
