% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MutatorMaybe.R
\name{dict_mutators_maybe}
\alias{dict_mutators_maybe}
\alias{MutatorMaybe}
\title{Mutator Choosing Action Probabilistically}
\description{
\code{\link{Mutator}} that chooses which operation to perform probabilistically. The \code{\link{Mutator}} wraps two other \code{\link{Mutator}}s given during construction,
and for each individuum, the operation to perform is sampled: with probability \code{p} (configuration parameter), the \code{\link{Mutator}} given to the \code{mutator}
construction argument is applied, and with probability \code{p - 1} the one given to \code{mutator_not} is applied.
}
\section{Configuration Parameters}{

This operator has the configuration parameters of the \code{\link{Mutator}}s that it wraps: The configuration parameters of the operator given to the \code{mutator} construction argument
are prefixed with \code{"maybe."}, the configuration parameters of the operator given to the \code{mutator_not} construction argument are prefixed with \code{"maybe_not."}.

Additional configuration parameters:
\itemize{
\item \code{p} :: \code{numeric(1)} \cr
Probability per individual with which to apply the operator given to the \code{mutator} construction argument. Must be set by the user.
}
}

\section{Supported Operand Types}{


Supported \code{\link[paradox:Param]{Param}} classes are the set intersection of supported classes of \code{mutator} and \code{mutator_not}.
}

\section{Dictionary}{

This \code{\link{Mutator}} can be created with the short access form \code{\link[=mut]{mut()}}
(\code{\link[=muts]{muts()}} to get a list), or through the the \link[mlr3misc:Dictionary]{dictionary}
\code{\link{dict_mutators}} in the following way:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# preferred:
mut("maybe", <mutator> [, <mutator_not>])
muts("maybe", <mutator> [, <mutator_not>])  # takes vector IDs, returns list of Mutators

# long form:
dict_mutators$get("maybe", <mutator> [, <mutator_not>])
}\if{html}{\out{</div>}}
}

\examples{
set.seed(1)
mm = mut("maybe", mut("gauss", sdev = 5), p = 0.5)
p = ps(x = p_int(-5, 5), y = p_dbl(-5, 5))
data = data.frame(x = rep(0, 5), y = rep(0, 5))

mm$prime(p)
mm$operate(data)

mm$param_set$values$p = 0.3
mm$operate(data)

mm2 = mut("maybe",
  mutator = mut("gauss", sdev = 0.01),
  mutator_not = mut("gauss", sdev = 10),
  p = 0.5
)

mm2$prime(p)
mm2$operate(data)
}
\seealso{
Other mutators: 
\code{\link{MutatorDiscrete}},
\code{\link{MutatorNumeric}},
\code{\link{Mutator}},
\code{\link{OperatorCombination}},
\code{\link{dict_mutators_cmpmaybe}},
\code{\link{dict_mutators_erase}},
\code{\link{dict_mutators_gauss}},
\code{\link{dict_mutators_null}},
\code{\link{dict_mutators_proxy}},
\code{\link{dict_mutators_sequential}},
\code{\link{dict_mutators_unif}}

Other mutator wrappers: 
\code{\link{OperatorCombination}},
\code{\link{dict_mutators_cmpmaybe}},
\code{\link{dict_mutators_proxy}},
\code{\link{dict_mutators_sequential}}
}
\concept{mutator wrappers}
\concept{mutators}
\section{Super classes}{
\code{\link[miesmuschel:MiesOperator]{miesmuschel::MiesOperator}} -> \code{\link[miesmuschel:Mutator]{miesmuschel::Mutator}} -> \code{MutatorMaybe}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{mutator}}{(\code{\link{Mutator}})\cr
\code{\link{Mutator}} being wrapped. This operator gets run with probability \code{p} (configuration parameter).}

\item{\code{mutator_not}}{(\code{\link{Mutator}})\cr
Alternative \code{\link{Mutator}} being wrapped. This operator gets run with probability \code{1 - p} (configuration parameter).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MutatorMaybe-new}{\code{MutatorMaybe$new()}}
\item \href{#method-MutatorMaybe-prime}{\code{MutatorMaybe$prime()}}
\item \href{#method-MutatorMaybe-clone}{\code{MutatorMaybe$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="help"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-help'><code>miesmuschel::MiesOperator$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="operate"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-operate'><code>miesmuschel::MiesOperator$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="print"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-print'><code>miesmuschel::MiesOperator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="repr"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-repr'><code>miesmuschel::MiesOperator$repr()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MutatorMaybe-new"></a>}}
\if{latex}{\out{\hypertarget{method-MutatorMaybe-new}{}}}
\subsection{Method \code{new()}}{
Initialize the \code{MutatorMaybe} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MutatorMaybe$new(mutator, mutator_not = MutatorNull$new())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mutator}}{(\code{\link{Mutator}})\cr
\code{\link{Mutator}} to wrap. This operator gets run with probability \code{p} (configuration parameter).\cr
The constructed object gets a \emph{clone} of this argument.\cr
The \verb{$mutator} field will reflect this value.}

\item{\code{mutator_not}}{(\code{\link{Mutator}})\cr
Another \code{\link{Mutator}} to wrap. This operator runs when \code{mutator} is not chosen. By
default, this is \code{\link{MutatorNull}}, i.e. no operation. With this default, the
\code{MutatorMaybe} object applies the \code{mutator} operation with probability \code{p}, and
no operation at all otherwise.\cr
The constructed object gets a \emph{clone} of this argument.
The \verb{$mutator_not} field will reflect this value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MutatorMaybe-prime"></a>}}
\if{latex}{\out{\hypertarget{method-MutatorMaybe-prime}{}}}
\subsection{Method \code{prime()}}{
See \code{\link{MiesOperator}} method. Primes both this operator, as well as the wrapped operators
given to \code{mutator} and \code{mutator_not} during construction.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MutatorMaybe$prime(param_set)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param_set}}{(\code{\link[paradox:ParamSet]{ParamSet}})\cr
Passed to \code{\link{MiesOperator}}\verb{$prime()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{invisible} \code{self}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MutatorMaybe-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MutatorMaybe-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MutatorMaybe$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
